/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api;

import com.xing.api.Callback;
import com.xing.api.HttpError;
import com.xing.api.HttpMethod;
import com.xing.api.RealCallSpec;
import com.xing.api.Response;
import com.xing.api.UrlEscapeUtils;
import com.xing.api.Utils;
import com.xing.api.XingApi;
import io.reactivex.Completable;
import io.reactivex.Single;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;

public interface CallSpec<RT, ET>
extends Cloneable {
    public Response<RT, ET> execute() throws IOException;

    public void enqueue(Callback<RT, ET> var1);

    public Single<RT> singleResponse();

    public Completable completableResponse();

    public Single<Response<RT, ET>> singleRawResponse();

    public boolean isExecuted();

    public boolean isCanceled();

    public void cancel();

    public CallSpec<RT, ET> header(String var1, String var2);

    public CallSpec<RT, ET> queryParam(String var1, Object var2);

    public CallSpec<RT, ET> queryParam(String var1, String var2);

    public CallSpec<RT, ET> queryParam(String var1, String ... var2);

    public CallSpec<RT, ET> queryParam(String var1, List<String> var2);

    public CallSpec<RT, ET> formField(String var1, String var2, boolean var3);

    public CallSpec<RT, ET> formField(String var1, String var2);

    public CallSpec<RT, ET> formField(String var1, Object var2);

    public CallSpec<RT, ET> formField(String var1, String ... var2);

    public CallSpec<RT, ET> formField(String var1, List<String> var2);

    public CallSpec<RT, ET> connectTimeout(int var1);

    public CallSpec<RT, ET> readTimeout(int var1);

    public CallSpec<RT, ET> writeTimeout(int var1);

    public CallSpec<RT, ET> clone();

    public Request request();

    public static final class Builder<RT, ET> {
        private static final String PARAM = "[a-zA-Z][a-zA-Z0-9_-]*";
        private static final Pattern PARAM_NAME_REGEX = Pattern.compile("[a-zA-Z][a-zA-Z0-9_-]*");
        private static final Pattern PARAM_URL_REGEX = Pattern.compile("\\{([a-zA-Z][a-zA-Z0-9_-]*)\\}");
        private final HttpMethod httpMethod;
        private final HttpUrl apiEndpoint;
        private final Request.Builder requestBuilder;
        private final Set<String> resourcePathParams;
        private String resourcePath;
        private HttpUrl.Builder urlBuilder;
        private FormBody.Builder formBodyBuilder;
        private RequestBody body;
        final XingApi api;
        Type responseType;
        Type errorType;
        int connectTimeout = -1;
        int readTimeout = -1;
        int writeTimeout = -1;

        Builder(XingApi api, HttpMethod httpMethod, String resourcePath, boolean isFormEncoded) {
            this.api = api;
            this.httpMethod = Utils.checkNotNull(httpMethod, "httpMethod == null");
            this.resourcePath = Utils.checkNotNull(resourcePath, "resourcePath == null");
            this.resourcePathParams = Builder.parseResourcePathParams(resourcePath);
            this.apiEndpoint = api.apiEndpoint();
            this.requestBuilder = new Request.Builder().header("Accept", "application/json");
            if (isFormEncoded) {
                this.formBodyBuilder = new FormBody.Builder();
            }
        }

        private Builder(Builder<RT, ET> builder) {
            this.api = builder.api;
            this.httpMethod = builder.httpMethod;
            this.apiEndpoint = builder.apiEndpoint;
            this.requestBuilder = builder.requestBuilder;
            this.resourcePathParams = builder.resourcePathParams;
            this.resourcePath = builder.resourcePath;
            this.urlBuilder = builder.urlBuilder;
            this.formBodyBuilder = builder.formBodyBuilder;
            this.body = builder.body;
            this.responseType = builder.responseType;
            this.errorType = builder.errorType;
            this.connectTimeout = builder.connectTimeout;
            this.readTimeout = builder.readTimeout;
            this.writeTimeout = builder.writeTimeout;
        }

        public Builder<RT, ET> pathParam(String name, String value) {
            return this.pathParam(name, value, false);
        }

        public Builder<RT, ET> pathParam(String name, String ... values) {
            return this.pathParam(name, Builder.toCsv(values, false), true);
        }

        public Builder<RT, ET> pathParam(String name, List<String> values) {
            return this.pathParam(name, Builder.toCsv(values, false), true);
        }

        private Builder<RT, ET> pathParam(String name, String value, boolean encoded) {
            Utils.stateNotNull(this.resourcePath, "Path params must be set before query params.");
            this.validatePathParam(name);
            this.resourcePath = this.resourcePath.replace('{' + name + '}', encoded ? value : UrlEscapeUtils.escape(value));
            this.resourcePathParams.remove(name);
            return this;
        }

        public Builder<RT, ET> queryParam(String name, Object value) {
            if (this.resourcePath != null) {
                this.buildUrlBuilder();
            }
            this.urlBuilder.addEncodedQueryParameter(name, UrlEscapeUtils.escape(String.valueOf(value)));
            return this;
        }

        public Builder<RT, ET> queryParam(String name, String ... values) {
            return this.queryParam(name, (Object)Builder.toCsv(values, false));
        }

        public Builder<RT, ET> queryParam(String name, List<String> values) {
            return this.queryParam(name, (Object)Builder.toCsv(values, false));
        }

        public Builder<RT, ET> formField(String name, String value, boolean encode) {
            Utils.stateNotNull(this.formBodyBuilder, "form fields are not accepted by this request.");
            this.formBodyBuilder.add(name, encode ? UrlEscapeUtils.escape(value) : value);
            return this;
        }

        public Builder<RT, ET> formField(String name, String value) {
            return this.formField(name, value, false);
        }

        public Builder<RT, ET> formField(String name, Object value) {
            Utils.stateNotNull(this.formBodyBuilder, "form fields are not accepted by this request.");
            this.formBodyBuilder.add(name, String.valueOf(value));
            return this;
        }

        public Builder<RT, ET> formField(String name, String ... values) {
            Utils.stateNotNull(this.formBodyBuilder, "form fields are not accepted by this request.");
            this.formBodyBuilder.add(name, Builder.toCsv(values, true));
            return this;
        }

        public Builder<RT, ET> formField(String name, List<String> values) {
            Utils.stateNotNull(this.formBodyBuilder, "form fields are not accepted by this request.");
            this.formBodyBuilder.add(name, Builder.toCsv(values, true));
            return this;
        }

        public Builder<RT, ET> connectTimeout(int connectTimeout) {
            if (connectTimeout < 0) {
                throw new IllegalArgumentException("timeout must be >= 0");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder<RT, ET> readTimeout(int readTimeout) {
            if (readTimeout < 0) {
                throw new IllegalArgumentException("timeout must be >= 0");
            }
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder<RT, ET> writeTimeout(int writeTimeout) {
            if (writeTimeout < 0) {
                throw new IllegalArgumentException("timeout must be >= 0");
            }
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder<RT, ET> body(RequestBody body) {
            this.body = body;
            return this;
        }

        public <U> Builder<RT, ET> body(Type type, U body) {
            return this.body(this.api.converter().convertToBody(type, body));
        }

        public Builder<RT, ET> header(String name, String value) {
            this.requestBuilder.header(name, value);
            return this;
        }

        public Builder<RT, ET> responseAs(Class<RT> type) {
            return this.responseAs((Type)type);
        }

        public Builder<RT, ET> responseAs(Type type) {
            this.responseType = Utils.checkNotNull(type, "type == null");
            return this;
        }

        public Builder<RT, ET> errorAs(Class<ET> type) {
            return this.errorAs((Type)type);
        }

        public Builder<RT, ET> errorAs(Type type) {
            this.errorType = Utils.checkNotNull(type, "type == null");
            return this;
        }

        public CallSpec<RT, ET> build() {
            if (!this.resourcePathParams.isEmpty()) {
                throw Utils.stateError("Not all path params where set. Found %d unsatisfied parameter(s)", this.resourcePathParams.size());
            }
            if (this.urlBuilder == null) {
                this.buildUrlBuilder();
            }
            if (this.responseType == null) {
                throw Utils.stateError("Response type is not set.", new Object[0]);
            }
            if (this.errorType == null) {
                this.errorType = HttpError.class;
            }
            return new RealCallSpec(this);
        }

        Request request() {
            if (this.urlBuilder == null) {
                throw Utils.stateError("#request() can be called only after #build()", new Object[0]);
            }
            HttpUrl url = this.urlBuilder.build();
            RequestBody body = this.body;
            if (body == null) {
                if (this.formBodyBuilder != null) {
                    body = this.formBodyBuilder.build();
                } else if (this.httpMethod.hasBody()) {
                    body = RequestBody.create(null, (byte[])new byte[0]);
                }
            }
            return this.requestBuilder.url(url).method(this.httpMethod.method(), body).build();
        }

        Builder<RT, ET> newBuilder() {
            return new Builder<RT, ET>(this);
        }

        private void buildUrlBuilder() {
            this.urlBuilder = this.apiEndpoint.resolve(this.resourcePath).newBuilder();
            this.resourcePath = null;
        }

        private void validatePathParam(String name) {
            if (!PARAM_NAME_REGEX.matcher(name).matches()) {
                throw Utils.assertionError("Path parameter name must match %s. Found: %s", PARAM_URL_REGEX.pattern(), name);
            }
            if (!this.resourcePathParams.contains(name)) {
                throw Utils.assertionError("Resource path \"%s\" does not contain \"{%s}\". Or the path parameter has been already set.", this.resourcePath, name);
            }
        }

        static Set<String> parseResourcePathParams(String resourcePath) {
            Matcher matcher = PARAM_URL_REGEX.matcher(resourcePath);
            LinkedHashSet<String> patterns = new LinkedHashSet<String>();
            while (matcher.find()) {
                patterns.add(matcher.group(1));
            }
            return patterns;
        }

        static String toCsv(Object[] values, boolean withSpace) {
            return Builder.toCsv(values != null ? Arrays.asList(values) : Collections.emptyList(), withSpace);
        }

        static String toCsv(List<?> values, boolean withSpace) {
            StringBuilder sb = new StringBuilder();
            if (values != null && !values.isEmpty()) {
                int size = values.size();
                if (size > 1) {
                    boolean firstTime = true;
                    for (int index = 0; index < size; ++index) {
                        if (firstTime) {
                            firstTime = false;
                        } else {
                            sb.append(withSpace ? ", " : Character.valueOf(','));
                        }
                        sb.append(values.get(index));
                    }
                } else {
                    sb.append(values.get(0));
                }
            }
            return sb.toString();
        }
    }
}

