/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ContentRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final Pattern HEADER_PATTERN = Pattern.compile("^items ((\\d+)-(\\d+)|\\*)/(\\d+|\\*)\\z");
    static final String HEADER_NAME = "Xing-Content-Range";
    private final int offset;
    private final int last;
    private final int total;

    static ContentRange parse(String headerValue) {
        Matcher matcher;
        if (headerValue != null && (matcher = HEADER_PATTERN.matcher(headerValue)).find()) {
            String tail;
            int offset = -1;
            int last = -1;
            int total = -1;
            String head = matcher.group(1);
            if (!"*".equals(head)) {
                offset = Integer.parseInt(matcher.group(2));
                last = Integer.parseInt(matcher.group(3));
            }
            if (!"*".equals(tail = matcher.group(4))) {
                total = Integer.parseInt(tail);
            }
            return new ContentRange(offset, last, total);
        }
        return null;
    }

    ContentRange(int offset, int last, int total) {
        this.offset = offset;
        this.last = last;
        this.total = total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentRange range = (ContentRange)o;
        return this.offset == range.offset && this.last == range.last && this.total == range.total;
    }

    public int hashCode() {
        int result = this.offset;
        result = 31 * result + this.last;
        result = 31 * result + this.total;
        return result;
    }

    public String toString() {
        return "Xing-Content-Range: items " + (this.offset < 0 || this.last < 0 ? "*" : this.offset + "-" + this.last) + '/' + (this.total >= 0 ? Integer.valueOf(this.total) : "*");
    }

    public int offset() {
        return this.offset;
    }

    public int last() {
        return this.last;
    }

    public int total() {
        return this.total;
    }

    public boolean isEmpty() {
        return this.total == 0;
    }
}

