/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.xing.api.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

final class Converter {
    static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final Map<Object, JsonAdapter<?>> adapterCache = new LinkedHashMap();
    private final Moshi moshi;

    static Type single(Type searchFor, String ... roots) {
        return new CompositeType(searchFor, roots);
    }

    static Type list(Type searchFor, String ... roots) {
        return new CompositeType(new ListTypeImpl(searchFor), roots);
    }

    static Type first(Type searchFor, String ... roots) {
        return new CompositeType(new ListTypeImpl(searchFor, true), roots);
    }

    public Converter(Moshi moshi) {
        this.moshi = moshi;
    }

    public Moshi moshi() {
        return this.moshi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R convertFromBody(Type type, ResponseBody body) throws IOException {
        if (body == null) {
            return null;
        }
        try {
            if (type == Void.class) {
                R r = null;
                return r;
            }
            if (type == String.class) {
                String string = body.string();
                return (R)string;
            }
            if (type == ResponseBody.class) {
                ResponseBody responseBody = Utils.buffer(body);
                return (R)responseBody;
            }
            JsonAdapter adapter = this.findAdapter(type);
            JsonReader reader = JsonReader.of((BufferedSource)body.source());
            Object object = adapter.fromJson(reader);
            return (R)object;
        }
        finally {
            Utils.closeQuietly((Closeable)body);
        }
    }

    public <B> RequestBody convertToBody(Type type, B body) {
        Buffer buffer = new Buffer();
        JsonAdapter jsonAdapter = this.findAdapter(type);
        try {
            jsonAdapter.toJson((BufferedSink)buffer, body);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return RequestBody.create((MediaType)MEDIA_TYPE_JSON, (byte[])buffer.readByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> JsonAdapter<T> findAdapter(Type type) {
        if (type instanceof CompositeType) {
            JsonAdapter<?> adapter;
            CompositeType compositeType = (CompositeType)type;
            Map<Object, JsonAdapter<?>> map = this.adapterCache;
            synchronized (map) {
                adapter = this.adapterCache.get(compositeType);
                if (adapter != null) {
                    return adapter;
                }
            }
            JsonAdapter<T> delegate = this.findAdapter(compositeType.searchFor);
            adapter = new CompositeJsonAdapter(delegate, compositeType.roots);
            Map<Object, JsonAdapter<?>> map2 = this.adapterCache;
            synchronized (map2) {
                this.adapterCache.put(compositeType, adapter);
            }
            return adapter;
        }
        if (type instanceof ListTypeImpl) {
            JsonAdapter<?> adapter;
            ListTypeImpl listType = (ListTypeImpl)type;
            Map<Object, JsonAdapter<?>> delegate = this.adapterCache;
            synchronized (delegate) {
                adapter = this.adapterCache.get(listType);
                if (adapter != null) {
                    return adapter;
                }
            }
            delegate = this.findAdapter(listType.type);
            adapter = new ListTypeImplJsonAdapter((JsonAdapter<?>)delegate, listType.isFirst);
            Map<Object, JsonAdapter<?>> map = this.adapterCache;
            synchronized (map) {
                this.adapterCache.put(listType, adapter);
            }
            return adapter;
        }
        return this.moshi.adapter(type);
    }

    private static final class ListTypeImplJsonAdapter<T>
    extends JsonAdapter<T> {
        private final JsonAdapter<T> elementAdapter;
        private final boolean isFirst;

        ListTypeImplJsonAdapter(JsonAdapter<T> elementAdapter, boolean isFirst) {
            this.elementAdapter = elementAdapter;
            this.isFirst = isFirst;
        }

        public T fromJson(JsonReader reader) throws IOException {
            ArrayList<Object> result = new ArrayList<Object>();
            reader.beginArray();
            while (reader.hasNext()) {
                result.add(this.elementAdapter.fromJson(reader));
            }
            reader.endArray();
            if (this.isFirst) {
                return !result.isEmpty() ? (T)result.get(0) : null;
            }
            return (T)result;
        }

        public void toJson(JsonWriter writer, T value) throws IOException {
            writer.beginArray();
            List<T> list = value instanceof List ? (List<T>)value : Collections.singletonList(value);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                T element = list.get(i);
                this.elementAdapter.toJson(writer, element);
            }
            writer.endArray();
        }

        public String toString() {
            return this.elementAdapter + ".listTypeImpl()" + (this.isFirst ? ".first()" : "");
        }
    }

    private static final class ListTypeImpl
    implements Type {
        final Type type;
        final boolean isFirst;

        ListTypeImpl(Type type) {
            this(type, false);
        }

        ListTypeImpl(Type type, boolean isFirst) {
            this.type = type;
            this.isFirst = isFirst;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListTypeImpl listType = (ListTypeImpl)o;
            return this.type.equals(listType.type) && this.isFirst == listType.isFirst;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.isFirst ? 1 : 0);
            return result;
        }

        public String toString() {
            return "ListTypeImpl(" + this.type + ')' + (this.isFirst ? ".first()" : "");
        }
    }

    private static final class CompositeJsonAdapter<T>
    extends JsonAdapter<T> {
        private final JsonAdapter<T> adapter;
        private final String[] roots;

        CompositeJsonAdapter(JsonAdapter<T> adapter, String[] roots) {
            this.adapter = adapter;
            this.roots = roots;
        }

        public T fromJson(JsonReader reader) throws IOException {
            return CompositeJsonAdapter.readRootLeafs(this.adapter, reader, this.roots, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static <T> T readRootLeafs(JsonAdapter<T> adapter, JsonReader reader, String[] roots, int index) throws IOException {
            if (roots == null || index == roots.length) {
                return (T)adapter.fromJson(reader);
            }
            reader.beginObject();
            try {
                String root = roots[index];
                while (reader.hasNext()) {
                    if (reader.nextName().equals(root)) {
                        if (reader.peek() == JsonReader.Token.NULL) {
                            Object object = reader.nextNull();
                            return (T)object;
                        }
                        T t = CompositeJsonAdapter.readRootLeafs(adapter, reader, roots, ++index);
                        return t;
                    }
                    reader.skipValue();
                }
            }
            finally {
                while (reader.hasNext()) {
                    reader.skipValue();
                }
                reader.endObject();
            }
            throw new IOException(String.format("Json does not match expected structure for roots %s.", Arrays.asList(roots)));
        }

        public void toJson(JsonWriter writer, T value) {
            try {
                CompositeJsonAdapter.writeRootLeafs(this.adapter, writer, value, this.roots, 0);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        private static <T> void writeRootLeafs(JsonAdapter<T> adapter, JsonWriter writer, T value, String[] roots, int index) throws IOException {
            if (roots == null || index == roots.length) {
                adapter.toJson(writer, value);
            } else {
                writer.beginObject();
                CompositeJsonAdapter.writeRootLeafs(adapter, writer.name(roots[index]), value, roots, ++index);
                writer.endObject();
            }
        }

        public String toString() {
            return this.adapter + String.format(".compositeAt(%s)", Arrays.asList(this.roots));
        }
    }

    private static final class CompositeType
    implements Type {
        private static final String[] NO_ROOTS = new String[0];
        final Type searchFor;
        final String[] roots;

        CompositeType(Type searchFor, String ... roots) {
            this.searchFor = searchFor;
            this.roots = roots != null ? roots : NO_ROOTS;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CompositeType compareTo = (CompositeType)obj;
            if (this.searchFor != null ? !this.searchFor.equals(compareTo.searchFor) : compareTo.searchFor != null) {
                return false;
            }
            return Arrays.equals(this.roots, compareTo.roots);
        }

        public int hashCode() {
            int result = this.searchFor != null ? this.searchFor.hashCode() : 0;
            result = 31 * result + (this.roots != null ? Arrays.hashCode(this.roots) : 0);
            return result;
        }

        public String toString() {
            return "CompositeType(" + this.searchFor + ')';
        }
    }
}

