/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api;

import com.xing.api.AuthErrorCallback;
import com.xing.api.Callback;
import com.xing.api.CallbackAdapter;
import com.xing.api.Response;
import java.util.concurrent.Executor;
import okhttp3.ResponseBody;

final class ExecutorCallbackAdapter
implements CallbackAdapter {
    private final Executor executor;

    public ExecutorCallbackAdapter(Executor executor) {
        this.executor = executor;
    }

    @Override
    public <RT, ET> Callback<RT, ET> adapt(final Callback<RT, ET> callback) {
        return new Callback<RT, ET>(){

            @Override
            public void onResponse(final Response<RT, ET> response) {
                ExecutorCallbackAdapter.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onResponse(response);
                    }
                });
            }

            @Override
            public void onFailure(final Throwable t) {
                ExecutorCallbackAdapter.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFailure(t);
                    }
                });
            }
        };
    }

    @Override
    public AuthErrorCallback adapt(final AuthErrorCallback callback) {
        return new AuthErrorCallback(){

            @Override
            public void onAuthError(final Response<?, ResponseBody> errorResponse) {
                ExecutorCallbackAdapter.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onAuthError(errorResponse);
                    }
                });
            }
        };
    }
}

