/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api;

import com.squareup.moshi.Json;
import java.util.List;

public class HttpError {
    @Json(name="error_name")
    private final String errorName;
    @Json(name="message")
    private final String errorMessage;
    @Json(name="errors")
    private final List<Error> errors;

    HttpError(String errorName, String errorMessage, List<Error> errors) {
        this.errorName = errorName;
        this.errorMessage = errorMessage;
        this.errors = errors;
    }

    public String toString() {
        return "ErrorBody{name='" + this.errorName + '\'' + ", message='" + this.errorMessage + '\'' + ", errors=" + this.errors + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpError error = (HttpError)o;
        return (this.errorName != null ? this.errorName.equals(error.errorName) : error.errorName == null) && (this.errorMessage != null ? this.errorMessage.equals(error.errorMessage) : error.errorMessage == null) && (this.errors != null ? this.errors.equals(error.errors) : error.errors == null);
    }

    public int hashCode() {
        int result = this.errorName != null ? this.errorName.hashCode() : 0;
        result = 31 * result + (this.errorMessage != null ? this.errorMessage.hashCode() : 0);
        result = 31 * result + (this.errors != null ? this.errors.hashCode() : 0);
        return result;
    }

    public String name() {
        return this.errorName;
    }

    public String message() {
        return this.errorMessage;
    }

    public List<Error> errors() {
        return this.errors;
    }

    public static final class Error {
        @Json(name="field")
        public final String field;
        @Json(name="reason")
        public final Reason reason;

        Error(String field, Reason reason) {
            this.field = field;
            this.reason = reason;
        }

        public String toString() {
            return "Error{field='" + this.field + '\'' + ", reason=" + (Object)((Object)this.reason) + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Error error = (Error)o;
            return (this.field != null ? this.field.equals(error.field) : error.field == null) && this.reason == error.reason;
        }

        public int hashCode() {
            int result = this.field != null ? this.field.hashCode() : 0;
            result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
            return result;
        }

        public static enum Reason {
            UNEXPECTED("UNEXPECTED"),
            UNEXPECTED_VALUE("UNEXPECTED_VALUE"),
            MISSING("MISSING"),
            INVALID_FORMAT("INVALID_FORMAT"),
            NOT_UNIQUE("NOT_UNIQUE"),
            UNKNOWN_VALUE("UNKNOWN_VALUE"),
            TOO_SHORT("TOO_SHORT"),
            TOO_LONG("TOO_LONG"),
            LOWER_BOUND_EXCEEDED("LOWER_BOUND_EXCEEDED"),
            FIELD_DEPRECATED("FIELD_DEPRECATED"),
            TOO_MANY_ENTRIES("TOO_MANY_ENTRIES");

            final String text;

            private Reason(String text) {
                this.text = text;
            }

            public String toString() {
                return this.text;
            }
        }
    }
}

