/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api;

import com.xing.api.UrlEscapeUtils;
import com.xing.api.Utils;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.regex.Pattern;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;

final class OAuth1SigningInterceptor
implements Interceptor {
    private static final Pattern CHARACTER_PATTERN = Pattern.compile("\\W");
    private static final int NUANCE_BYTES = 32;
    private static final String OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    private static final String OAUTH_NONCE = "oauth_nonce";
    private static final String OAUTH_SIGNATURE = "oauth_signature";
    private static final String OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    private static final String OAUTH_SIGNATURE_METHOD_VALUE = "HMAC-SHA1";
    private static final String OAUTH_TIMESTAMP = "oauth_timestamp";
    private static final String OAUTH_ACCESS_TOKEN = "oauth_token";
    private static final String OAUTH_VERSION = "oauth_version";
    private static final String OAUTH_VERSION_VALUE = "1.0";
    private static final MediaType FORM_ENCODED_CONTENT_TYPE = MediaType.parse((String)"application/x-www-form-urlencoded");
    private final String consumerKey;
    private final String consumerSecret;
    private final String accessToken;
    private final String accessSecret;
    private final Random random;
    private final Clock clock;

    OAuth1SigningInterceptor(String consumerKey, String consumerSecret, String accessToken, String accessSecret, Random random, Clock clock) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.accessToken = accessToken;
        this.accessSecret = accessSecret;
        this.random = random;
        this.clock = clock;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return chain.proceed(this.signRequest(chain.request()));
    }

    Request signRequest(Request request) throws IOException {
        byte[] nonce = new byte[32];
        this.random.nextBytes(nonce);
        String oauthNonce = CHARACTER_PATTERN.matcher(ByteString.of((byte[])nonce).base64()).replaceAll("");
        String oauthTimestamp = this.clock.millis();
        String consumerKeyValue = UrlEscapeUtils.escape(this.consumerKey);
        String accessTokenValue = UrlEscapeUtils.escape(this.accessToken);
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put(OAUTH_CONSUMER_KEY, consumerKeyValue);
        parameters.put(OAUTH_ACCESS_TOKEN, accessTokenValue);
        parameters.put(OAUTH_NONCE, oauthNonce);
        parameters.put(OAUTH_TIMESTAMP, oauthTimestamp);
        parameters.put(OAUTH_SIGNATURE_METHOD, OAUTH_SIGNATURE_METHOD_VALUE);
        parameters.put(OAUTH_VERSION, OAUTH_VERSION_VALUE);
        HttpUrl url = request.url();
        for (int i = 0; i < url.querySize(); ++i) {
            parameters.put(UrlEscapeUtils.escape(url.queryParameterName(i)), UrlEscapeUtils.escape(url.queryParameterValue(i)));
        }
        Buffer body = new Buffer();
        RequestBody requestBody = request.body();
        if (requestBody != null && FORM_ENCODED_CONTENT_TYPE.equals((Object)requestBody.contentType())) {
            requestBody.writeTo((BufferedSink)body);
        }
        while (!body.exhausted()) {
            String value;
            long keyEnd = body.indexOf((byte)61);
            if (keyEnd == -1L) {
                throw new IllegalStateException("Key with no value: " + body.readUtf8());
            }
            String key = body.readUtf8(keyEnd);
            body.skip(1L);
            long valueEnd = body.indexOf((byte)38);
            String string = value = valueEnd == -1L ? body.readUtf8() : body.readUtf8(valueEnd);
            if (valueEnd != -1L) {
                body.skip(1L);
            }
            parameters.put(key, value);
        }
        Buffer base = new Buffer();
        String method = request.method();
        base.writeUtf8(method);
        base.writeByte(38);
        base.writeUtf8(UrlEscapeUtils.escape(request.url().newBuilder().query(null).build().toString()));
        base.writeByte(38);
        boolean first = true;
        for (Map.Entry entry : parameters.entrySet()) {
            if (!first) {
                base.writeUtf8(UrlEscapeUtils.escape("&"));
            }
            first = false;
            base.writeUtf8(UrlEscapeUtils.escape((String)entry.getKey()));
            base.writeUtf8(UrlEscapeUtils.escape("="));
            base.writeUtf8(UrlEscapeUtils.escape((String)entry.getValue()));
        }
        String signingKey = UrlEscapeUtils.escape(this.consumerSecret) + '&' + UrlEscapeUtils.escape(this.accessSecret);
        String signature = base.hmacSha1(ByteString.encodeUtf8((String)signingKey)).base64();
        String authorization = "OAuth oauth_consumer_key=\"" + consumerKeyValue + "\", " + OAUTH_NONCE + "=\"" + oauthNonce + "\", " + OAUTH_SIGNATURE + "=\"" + UrlEscapeUtils.escape(signature) + "\", " + OAUTH_SIGNATURE_METHOD + "=\"" + OAUTH_SIGNATURE_METHOD_VALUE + "\", " + OAUTH_TIMESTAMP + "=\"" + oauthTimestamp + "\", " + OAUTH_ACCESS_TOKEN + "=\"" + accessTokenValue + "\", " + OAUTH_VERSION + "=\"" + OAUTH_VERSION_VALUE + '\"';
        return request.newBuilder().addHeader("Authorization", authorization).build();
    }

    static class Clock {
        Clock() {
        }

        public String millis() {
            return Long.toString(System.currentTimeMillis() / 1000L);
        }
    }

    public static final class Builder {
        private String consumerKey;
        private String consumerSecret;
        private String accessToken;
        private String accessSecret;
        private Random random = new SecureRandom();
        private Clock clock = new Clock();

        public Builder consumerKey(String consumerKey) {
            this.consumerKey = Utils.checkNotNull(consumerKey, "consumerKey == null");
            return this;
        }

        public Builder consumerSecret(String consumerSecret) {
            this.consumerSecret = Utils.checkNotNull(consumerSecret, "consumerSecret == null");
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = Utils.checkNotNull(accessToken, "accessToken == null");
            return this;
        }

        public Builder accessSecret(String accessSecret) {
            this.accessSecret = Utils.checkNotNull(accessSecret, "accessSecret == null");
            return this;
        }

        public Builder random(Random random) {
            this.random = Utils.checkNotNull(random, "random == null");
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = Utils.checkNotNull(clock, "clock == null");
            return this;
        }

        public OAuth1SigningInterceptor build() {
            Utils.stateNotNull(this.consumerKey, "consumerKey not set");
            Utils.stateNotNull(this.consumerSecret, "consumerSecret not set");
            Utils.stateNotNull(this.accessToken, "accessToken not set");
            Utils.stateNotNull(this.accessSecret, "accessSecret not set");
            return new OAuth1SigningInterceptor(this.consumerKey, this.consumerSecret, this.accessToken, this.accessSecret, this.random, this.clock);
        }
    }
}

