/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.xing.api.CallbackAdapter;
import com.xing.api.ExecutorCallbackAdapter;
import java.util.concurrent.Executor;

class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    Platform() {
    }

    static Platform get() {
        return PLATFORM;
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new Android();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new Platform();
    }

    public CallbackAdapter callbackAdapter(Executor executor) {
        if (executor != null) {
            return new ExecutorCallbackAdapter(executor);
        }
        return new CallbackAdapter.Default();
    }

    static class Android
    extends Platform {
        Android() {
        }

        @Override
        public CallbackAdapter callbackAdapter(Executor executor) {
            if (executor == null) {
                executor = new MainThreadExecutor();
            }
            return new ExecutorCallbackAdapter(executor);
        }

        static class MainThreadExecutor
        implements Executor {
            private final Handler handler = new Handler(Looper.getMainLooper());

            MainThreadExecutor() {
            }

            @Override
            public void execute(Runnable runnable) {
                this.handler.post(runnable);
            }
        }
    }
}

