/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api;

import com.xing.api.CallSpec;
import com.xing.api.Callback;
import com.xing.api.ContentRange;
import com.xing.api.HttpException;
import com.xing.api.Response;
import com.xing.api.Utils;
import com.xing.api.XingApi;
import io.reactivex.Completable;
import io.reactivex.Single;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

final class RealCallSpec<RT, ET>
implements CallSpec<RT, ET> {
    final XingApi api;
    private final CallSpec.Builder<RT, ET> builder;
    private final Type responseType;
    private final Type errorType;
    private volatile Call rawCall;
    private boolean executed;
    private volatile boolean canceled;
    private int connectTimeout = -1;
    private int readTimeout = -1;
    private int writeTimeout = -1;

    RealCallSpec(CallSpec.Builder<RT, ET> builder) {
        this.builder = builder;
        this.api = builder.api;
        this.responseType = builder.responseType;
        this.errorType = builder.errorType;
        this.readTimeout = builder.readTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.writeTimeout = builder.writeTimeout;
    }

    @Override
    public CallSpec<RT, ET> clone() {
        return new RealCallSpec<RT, ET>(this.builder.newBuilder());
    }

    @Override
    public Request request() {
        return this.builder.request();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<RT, ET> execute() throws IOException {
        RealCallSpec realCallSpec = this;
        synchronized (realCallSpec) {
            if (this.executed) {
                throw Utils.stateError("Call already executed", new Object[0]);
            }
            this.executed = true;
        }
        Call rawCall = this.createRawCall();
        if (this.canceled) {
            rawCall.cancel();
        }
        this.rawCall = rawCall;
        return this.parseResponse(rawCall.execute());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(final Callback<RT, ET> callback) {
        RealCallSpec realCallSpec = this;
        synchronized (realCallSpec) {
            if (this.executed) {
                throw Utils.stateError("Call already executed", new Object[0]);
            }
            this.executed = true;
        }
        Call rawCall = this.createRawCall();
        if (this.canceled) {
            rawCall.cancel();
        }
        this.rawCall = rawCall;
        rawCall.enqueue(new okhttp3.Callback(){

            private void callFailure(Throwable e) {
                try {
                    RealCallSpec.this.api.callbackAdapter().adapt(callback).onFailure(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            private void callSuccess(Response<RT, ET> response) {
                try {
                    RealCallSpec.this.api.callbackAdapter().adapt(callback).onResponse(response);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            public void onFailure(Call call, IOException e) {
                this.callFailure(e);
            }

            public void onResponse(Call call, okhttp3.Response rawResponse) {
                Response response;
                try {
                    response = RealCallSpec.this.parseResponse(rawResponse);
                }
                catch (Throwable e) {
                    this.callFailure(e);
                    return;
                }
                this.callSuccess(response);
            }
        });
    }

    @Override
    public Single<Response<RT, ET>> singleRawResponse() {
        return Single.fromCallable(new ResponseCallable(this));
    }

    @Override
    public Single<RT> singleResponse() {
        ResponseCallable responseCallable = new ResponseCallable(this);
        return Single.fromCallable(new BodyCallable(responseCallable));
    }

    @Override
    public Completable completableResponse() {
        ResponseCallable responseCallable = new ResponseCallable(this);
        return Completable.fromCallable(new BodyCallable(responseCallable));
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void cancel() {
        this.canceled = true;
        Call rawCall = this.rawCall;
        if (rawCall != null) {
            rawCall.cancel();
        }
    }

    @Override
    public CallSpec<RT, ET> header(String name, String value) {
        this.builder.header(name, value);
        return this;
    }

    @Override
    public CallSpec<RT, ET> queryParam(String name, Object value) {
        this.builder.queryParam(name, value);
        return this;
    }

    @Override
    public CallSpec<RT, ET> queryParam(String name, String value) {
        this.builder.queryParam(name, (Object)value);
        return this;
    }

    @Override
    public CallSpec<RT, ET> queryParam(String name, String ... values) {
        this.builder.queryParam(name, values);
        return this;
    }

    @Override
    public CallSpec<RT, ET> queryParam(String name, List<String> values) {
        this.builder.queryParam(name, values);
        return this;
    }

    @Override
    public CallSpec<RT, ET> formField(String name, String value, boolean encode) {
        this.builder.formField(name, value, encode);
        return this;
    }

    @Override
    public CallSpec<RT, ET> formField(String name, String value) {
        this.builder.formField(name, value);
        return this;
    }

    @Override
    public CallSpec<RT, ET> formField(String name, Object value) {
        this.builder.formField(name, value);
        return this;
    }

    @Override
    public CallSpec<RT, ET> formField(String name, String ... values) {
        this.builder.formField(name, values);
        return this;
    }

    @Override
    public CallSpec<RT, ET> formField(String name, List<String> values) {
        this.builder.formField(name, values);
        return this;
    }

    @Override
    public CallSpec<RT, ET> connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public CallSpec<RT, ET> readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    public CallSpec<RT, ET> writeTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    private Call createRawCall() {
        OkHttpClient client = this.api.client();
        client = this.applyTimeouts(client);
        return client.newCall(this.builder.request());
    }

    private OkHttpClient applyTimeouts(OkHttpClient client) {
        if (this.connectTimeout >= 0 || this.readTimeout >= 0 || this.writeTimeout >= 0) {
            OkHttpClient.Builder builder = client.newBuilder();
            if (this.connectTimeout >= 0) {
                builder.connectTimeout((long)this.connectTimeout, TimeUnit.SECONDS);
            }
            if (this.readTimeout >= 0) {
                builder.readTimeout((long)this.readTimeout, TimeUnit.SECONDS);
            }
            if (this.writeTimeout >= 0) {
                builder.writeTimeout((long)this.writeTimeout, TimeUnit.SECONDS);
            }
            return builder.build();
        }
        return client;
    }

    Response<RT, ET> parseResponse(okhttp3.Response rawResponse) throws IOException {
        ResponseBody rawBody = rawResponse.body();
        rawResponse = rawResponse.newBuilder().body((ResponseBody)new NoContentResponseBody(rawBody.contentType(), rawBody.contentLength())).build();
        ExceptionCatchingRequestBody catchingBody = new ExceptionCatchingRequestBody(rawBody);
        int code = rawResponse.code();
        if (code < 200 || code >= 300) {
            try {
                if (code == 401) {
                    ResponseBody bufferedBody = Utils.buffer(catchingBody);
                    this.api.notifyAuthError(Response.error(bufferedBody, rawResponse));
                    throw new IOException("401 Unauthorized");
                }
                Object errorBody = this.api.converter().convertFromBody(this.errorType, catchingBody);
                Response response = Response.error(errorBody, rawResponse);
                return response;
            }
            catch (EOFException eofe) {
                Response response = Response.error(null, rawResponse);
                return response;
            }
            catch (RuntimeException e) {
                catchingBody.throwIfCaught();
                throw e;
            }
            finally {
                Utils.closeQuietly((Closeable)((Object)catchingBody));
            }
        }
        if (code == 204 || code == 205) {
            return Response.success(null, rawResponse);
        }
        try {
            Object body = this.api.converter().convertFromBody(this.responseType, catchingBody);
            String contentRange = rawResponse.header("Xing-Content-Range");
            Response response = Response.success(body, ContentRange.parse(contentRange), rawResponse);
            return response;
        }
        catch (RuntimeException e) {
            catchingBody.throwIfCaught();
            throw e;
        }
        finally {
            Utils.closeQuietly((Closeable)((Object)catchingBody));
        }
    }

    static final class ResponseCallable<RT, ET>
    implements Callable<Response<RT, ET>> {
        private final CallSpec<RT, ET> callSpec;

        ResponseCallable(CallSpec<RT, ET> callSpec) {
            this.callSpec = callSpec;
        }

        @Override
        public Response<RT, ET> call() throws IOException {
            return this.callSpec.clone().execute();
        }
    }

    static final class BodyCallable<RT, ET>
    implements Callable<RT> {
        private final Callable<Response<RT, ET>> callable;

        BodyCallable(Callable<Response<RT, ET>> callable) {
            this.callable = callable;
        }

        @Override
        public RT call() throws Exception {
            Response<RT, ET> response = this.callable.call();
            if (response.isSuccessful()) {
                return response.body();
            }
            throw new HttpException(response);
        }
    }

    static final class ExceptionCatchingRequestBody
    extends ResponseBody {
        private final ResponseBody delegate;
        IOException thrownException;

        ExceptionCatchingRequestBody(ResponseBody delegate) {
            this.delegate = delegate;
        }

        public MediaType contentType() {
            return this.delegate.contentType();
        }

        public long contentLength() {
            return this.delegate.contentLength();
        }

        public BufferedSource source() {
            BufferedSource delegateSource = this.delegate.source();
            return Okio.buffer((Source)new ForwardingSource((Source)delegateSource){

                public long read(Buffer sink, long byteCount) throws IOException {
                    try {
                        return super.read(sink, byteCount);
                    }
                    catch (IOException e) {
                        ExceptionCatchingRequestBody.this.thrownException = e;
                        throw e;
                    }
                }
            });
        }

        public void close() {
            this.delegate.close();
        }

        void throwIfCaught() throws IOException {
            if (this.thrownException != null) {
                throw this.thrownException;
            }
        }
    }

    static final class NoContentResponseBody
    extends ResponseBody {
        private final MediaType contentType;
        private final long contentLength;

        NoContentResponseBody(MediaType contentType, long contentLength) {
            this.contentType = contentType;
            this.contentLength = contentLength;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public long contentLength() {
            return this.contentLength;
        }

        public BufferedSource source() {
            throw new IllegalStateException("Cannot read raw response body of a parsed body.");
        }
    }
}

