/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api;

import com.xing.api.CallSpec;
import com.xing.api.Converter;
import com.xing.api.HttpMethod;
import com.xing.api.XingApi;
import java.lang.reflect.Type;

public abstract class Resource {
    protected static final String ME = "me";
    protected final XingApi api;

    protected Resource(XingApi api) {
        this.api = api;
    }

    protected static <RT, ET> CallSpec.Builder<RT, ET> newGetSpec(XingApi api, String resourcePath) {
        return new CallSpec.Builder(api, HttpMethod.GET, resourcePath, false);
    }

    protected static <RT, ET> CallSpec.Builder<RT, ET> newPostSpec(XingApi api, String resourcePath, boolean isFormEncoded) {
        return new CallSpec.Builder(api, HttpMethod.POST, resourcePath, isFormEncoded);
    }

    protected static <RT, ET> CallSpec.Builder<RT, ET> newPutSpec(XingApi api, String resourcePath, boolean isFormEncoded) {
        return new CallSpec.Builder(api, HttpMethod.PUT, resourcePath, isFormEncoded);
    }

    protected static <RT, ET> CallSpec.Builder<RT, ET> newDeleteSpec(XingApi api, String resourcePath, boolean isFormEncoded) {
        return new CallSpec.Builder(api, HttpMethod.DELETE, resourcePath, isFormEncoded);
    }

    protected static Type single(Type searchFor, String ... roots) {
        return Converter.single(searchFor, roots);
    }

    protected static Type list(Type searchFor, String ... roots) {
        return Converter.list(searchFor, roots);
    }

    protected static Type first(Type searchFor, String ... roots) {
        return Converter.first(searchFor, roots);
    }

    public static abstract class Factory {
        private final Class<? extends Resource> resourceCls;

        public Factory(Class<? extends Resource> resourceCls) {
            this.resourceCls = resourceCls;
        }

        final Resource create(Class<? extends Resource> cls, XingApi api) {
            return cls == this.resourceCls ? this.create(api) : null;
        }

        public abstract Resource create(XingApi var1);
    }
}

