/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api;

import com.xing.api.ContentRange;
import com.xing.api.Utils;
import okhttp3.Headers;

public final class Response<RT, ET> {
    private final okhttp3.Response rawResponse;
    private final ContentRange range;
    private final RT body;
    private final ET error;

    static <RT, ET> Response<RT, ET> success(RT body, okhttp3.Response rawResponse) {
        return new Response<RT, Object>(rawResponse, null, body, null);
    }

    static <RT, ET> Response<RT, ET> success(RT body, ContentRange range, okhttp3.Response rawResponse) {
        return new Response<RT, Object>(rawResponse, range, body, null);
    }

    static <RT, ET> Response<RT, ET> error(ET error, okhttp3.Response rawResponse) {
        return new Response<Object, ET>(rawResponse, null, null, error);
    }

    private Response(okhttp3.Response rawResponse, ContentRange range, RT body, ET error) {
        this.rawResponse = Utils.checkNotNull(rawResponse, "rawResponse == null");
        this.range = range;
        this.body = body;
        this.error = error;
    }

    public okhttp3.Response raw() {
        return this.rawResponse;
    }

    public int code() {
        return this.rawResponse.code();
    }

    public String message() {
        return this.rawResponse.message();
    }

    public Headers headers() {
        return this.rawResponse.headers();
    }

    public boolean isSuccessful() {
        return this.rawResponse.isSuccessful();
    }

    public RT body() {
        return this.body;
    }

    public ET error() {
        return this.error;
    }

    public ContentRange range() {
        return this.range;
    }
}

