/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api;

import java.io.Closeable;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;

final class Utils {
    static <T> T checkNotNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    static <T> void stateNotNull(T object, String message) {
        if (object == null) {
            throw new IllegalStateException(message);
        }
    }

    static <T> void stateNull(T object, String message) {
        if (object != null) {
            throw Utils.stateError(message, new Object[0]);
        }
    }

    static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static ResponseBody buffer(ResponseBody body) throws IOException {
        Buffer buffer = new Buffer();
        body.source().readAll((Sink)buffer);
        return ResponseBody.create((MediaType)body.contentType(), (long)body.contentLength(), (BufferedSource)buffer);
    }

    static RuntimeException assertionError(String message, Object ... args) {
        return Utils.assertionError(null, message, args);
    }

    static RuntimeException assertionError(Throwable cause, String message, Object ... args) {
        message = String.format(message, args);
        IllegalArgumentException error = new IllegalArgumentException(message);
        error.initCause(cause);
        return error;
    }

    static RuntimeException stateError(String message, Object ... args) {
        return Utils.stateError(null, message, args);
    }

    static RuntimeException stateError(Throwable cause, String message, Object ... args) {
        message = String.format(message, args);
        IllegalStateException error = new IllegalStateException(message);
        error.initCause(cause);
        return error;
    }

    private Utils() {
    }
}

