/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api;

import com.serjltt.moshi.adapters.FallbackEnum;
import com.serjltt.moshi.adapters.FallbackOnNull;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.KotlinJsonAdapterFactory;
import com.squareup.moshi.Moshi;
import com.xing.api.AuthErrorCallback;
import com.xing.api.CallbackAdapter;
import com.xing.api.Converter;
import com.xing.api.OAuth1SigningInterceptor;
import com.xing.api.Platform;
import com.xing.api.Resource;
import com.xing.api.Response;
import com.xing.api.Utils;
import com.xing.api.internal.Experimental;
import com.xing.api.internal.json.BirthDateJsonAdapter;
import com.xing.api.internal.json.ContactPathJsonAdapter;
import com.xing.api.internal.json.CsvCollectionJsonAdapter;
import com.xing.api.internal.json.GeoCodeJsonAdapter;
import com.xing.api.internal.json.PhoneJsonAdapter;
import com.xing.api.internal.json.SafeCalendarJsonAdapter;
import com.xing.api.internal.json.SafeEnumJsonAdapter;
import com.xing.api.internal.json.TimeZoneJsonAdapter;
import com.xing.api.resources.BookmarksResource;
import com.xing.api.resources.ContactsResource;
import com.xing.api.resources.GroupsResource;
import com.xing.api.resources.JobsResource;
import com.xing.api.resources.MessagesResource;
import com.xing.api.resources.MiscellaneousResource;
import com.xing.api.resources.ProfileEditingResource;
import com.xing.api.resources.ProfileVisitsResource;
import com.xing.api.resources.RecommendationsResource;
import com.xing.api.resources.UserProfilesResource;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;

public final class XingApi {
    private static final List<Resource.Factory> BUILT_IN_FACTORIES = new ArrayList<Resource.Factory>();
    private final Map<Class<? extends Resource>, Resource> resourcesCache = new LinkedHashMap<Class<? extends Resource>, Resource>();
    private final List<AuthErrorCallback> authErrorCallbacks = new LinkedList<AuthErrorCallback>();
    private final Set<Resource.Factory> resourceFactories;
    private final OkHttpClient client;
    private final HttpUrl apiEndpoint;
    private final Converter converter;
    private final CallbackAdapter callbackAdapter;
    private final Executor callbackExecutor;

    XingApi(OkHttpClient client, HttpUrl apiEndpoint, Converter converter, CallbackAdapter callbackAdapter, Executor callbackExecutor, List<Resource.Factory> resourceFactories) {
        this.client = client;
        this.apiEndpoint = apiEndpoint;
        this.converter = converter;
        this.callbackAdapter = callbackAdapter;
        this.callbackExecutor = callbackExecutor;
        this.resourceFactories = new LinkedHashSet<Resource.Factory>(resourceFactories);
        this.resourceFactories.addAll(BUILT_IN_FACTORIES);
    }

    public <T extends Resource> T resource(Class<T> resource) {
        Resource res = this.resourcesCache.get(Utils.checkNotNull(resource, "resource == null"));
        if (res == null) {
            for (Resource.Factory factory : this.resourceFactories) {
                res = factory.create(resource, this);
                if (res == null) continue;
                this.resourcesCache.put(resource, res);
                return (T)res;
            }
            XingApi.checkResourceClassDeclaration(resource);
            try {
                Constructor<T> constructor = resource.getDeclaredConstructor(XingApi.class);
                constructor.setAccessible(true);
                res = (Resource)constructor.newInstance(this);
                this.resourcesCache.put(resource, res);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Resource class malformed.", ex);
            }
        }
        return (T)res;
    }

    public HttpUrl apiEndpoint() {
        return this.apiEndpoint;
    }

    public Moshi moshi() {
        return this.converter.moshi();
    }

    public Executor callbackExecutor() {
        return this.callbackExecutor;
    }

    public OkHttpClient client() {
        return this.client;
    }

    public XingApi addAuthErrorCallback(AuthErrorCallback errorCallback) {
        this.authErrorCallbacks.add(errorCallback);
        return this;
    }

    public XingApi removeAuthErrorCallback(AuthErrorCallback errorCallback) {
        this.authErrorCallbacks.remove(errorCallback);
        return this;
    }

    CallbackAdapter callbackAdapter() {
        return this.callbackAdapter;
    }

    Converter converter() {
        return this.converter;
    }

    void notifyAuthError(Response<?, ResponseBody> rawResponse) {
        int size = this.authErrorCallbacks.size();
        for (int i = 0; i < size; ++i) {
            AuthErrorCallback callback = this.authErrorCallbacks.get(i);
            if (callback == null) continue;
            this.callbackAdapter.adapt(callback).onAuthError(rawResponse);
        }
    }

    private static void checkResourceClassDeclaration(Class<? extends Resource> resource) {
        int modifiers = resource.getModifiers();
        if (resource.isLocalClass() || resource.isMemberClass() && !Modifier.isStatic(modifiers)) {
            throw new IllegalArgumentException("Resource class must be declared static.");
        }
    }

    static {
        BUILT_IN_FACTORIES.add(BookmarksResource.FACTORY);
        BUILT_IN_FACTORIES.add(ContactsResource.FACTORY);
        BUILT_IN_FACTORIES.add(GroupsResource.FACTORY);
        BUILT_IN_FACTORIES.add(JobsResource.FACTORY);
        BUILT_IN_FACTORIES.add(MessagesResource.FACTORY);
        BUILT_IN_FACTORIES.add(MiscellaneousResource.FACTORY);
        BUILT_IN_FACTORIES.add(ProfileEditingResource.FACTORY);
        BUILT_IN_FACTORIES.add(ProfileVisitsResource.FACTORY);
        BUILT_IN_FACTORIES.add(RecommendationsResource.FACTORY);
        BUILT_IN_FACTORIES.add(UserProfilesResource.FACTORY);
    }

    public static class BuildStep<T extends BuildStep> {
        private final List<Resource.Factory> resourceFactory = new ArrayList<Resource.Factory>();
        private OkHttpClient.Builder clientBuilder;
        private Moshi.Builder moshiBuilder;
        private Executor callbackExecutor;
        private HttpUrl apiEndpoint = HttpUrl.parse((String)"https://api.xing.com/");

        BuildStep() {
        }

        public final T addResourceFactory(Resource.Factory factory) {
            this.resourceFactory.add(Utils.checkNotNull(factory, "factory == null"));
            return this.self();
        }

        public final T apiEndpoint(String apiEndpoint) {
            HttpUrl httpUrl = HttpUrl.parse((String)Utils.checkNotNull(apiEndpoint, "apiEndpoint == null"));
            if (httpUrl == null) {
                throw new IllegalArgumentException("Illegal endpoint URL: " + apiEndpoint);
            }
            return this.apiEndpoint(httpUrl);
        }

        public final T apiEndpoint(HttpUrl baseUrl) {
            this.apiEndpoint = Utils.checkNotNull(baseUrl, "apiEndpoint == null");
            return this.self();
        }

        public final T moshi(Moshi moshi) {
            Utils.stateNull(this.moshiBuilder, "Only one instance of Moshi is allowed");
            this.moshiBuilder = Utils.checkNotNull(moshi, "moshi == null").newBuilder();
            return this.self();
        }

        public final T callbackExecutor(Executor callbackExecutor) {
            this.callbackExecutor = Utils.checkNotNull(callbackExecutor, "callbackExecutor == null");
            return this.self();
        }

        public final T client(OkHttpClient client) {
            this.clientBuilder = Utils.checkNotNull(client, "client == null").newBuilder();
            return this.self();
        }

        OkHttpClient.Builder clientBuilder() {
            return this.clientBuilder != null ? this.clientBuilder : new OkHttpClient.Builder();
        }

        private T self() {
            return (T)this;
        }

        public final XingApi build() {
            if (this.moshiBuilder == null) {
                this.moshiBuilder = new Moshi.Builder();
            }
            this.moshiBuilder.add(FallbackOnNull.ADAPTER_FACTORY);
            this.moshiBuilder.add(FallbackEnum.ADAPTER_FACTORY);
            this.moshiBuilder.add((JsonAdapter.Factory)new KotlinJsonAdapterFactory());
            this.moshiBuilder.add(SafeEnumJsonAdapter.FACTORY);
            this.moshiBuilder.add(ContactPathJsonAdapter.FACTORY);
            this.moshiBuilder.add(BirthDateJsonAdapter.FACTORY);
            this.moshiBuilder.add(SafeCalendarJsonAdapter.FACTORY);
            this.moshiBuilder.add(PhoneJsonAdapter.FACTORY);
            this.moshiBuilder.add(CsvCollectionJsonAdapter.FACTORY);
            this.moshiBuilder.add(GeoCodeJsonAdapter.FACTORY);
            this.moshiBuilder.add(TimeZoneJsonAdapter.FACTORY);
            CallbackAdapter adapter = Platform.get().callbackAdapter(this.callbackExecutor);
            Converter converter = new Converter(this.moshiBuilder.build());
            return new XingApi(this.clientBuilder().build(), this.apiEndpoint, converter, adapter, this.callbackExecutor, this.resourceFactory);
        }
    }

    public static final class CustomStep
    extends BuildStep<CustomStep> {
        CustomStep() {
        }
    }

    public static final class LoggedOutStep
    extends BuildStep<LoggedOutStep> {
        LoggedOutStep() {
        }
    }

    public static final class OAuth1Step
    extends BuildStep<OAuth1Step> {
        private final OAuth1SigningInterceptor.Builder oauth1Builder = new OAuth1SigningInterceptor.Builder();

        OAuth1Step() {
        }

        public OAuth1Step consumerKey(String consumerKey) {
            this.oauth1Builder.consumerKey(consumerKey);
            return this;
        }

        public OAuth1Step consumerSecret(String consumerSecret) {
            this.oauth1Builder.consumerSecret(consumerSecret);
            return this;
        }

        public OAuth1Step accessToken(String accessToken) {
            this.oauth1Builder.accessToken(accessToken);
            return this;
        }

        public OAuth1Step accessSecret(String accessSecret) {
            this.oauth1Builder.accessSecret(accessSecret);
            return this;
        }

        @Override
        OkHttpClient.Builder clientBuilder() {
            OkHttpClient.Builder builder = super.clientBuilder();
            builder.addInterceptor((Interceptor)this.oauth1Builder.build());
            return builder;
        }
    }

    public static final class Builder {
        public OAuth1Step oauth1() {
            return new OAuth1Step();
        }

        public LoggedOutStep loggedOut() {
            return new LoggedOutStep();
        }

        @Experimental
        public CustomStep custom() {
            return new CustomStep();
        }
    }
}

