/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.data;

import java.io.Serializable;

public class GeoCode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int accuracy;
    private final double latitude;
    private final double longitude;

    public GeoCode(int accuracy, double latitude, double longitude) {
        this.accuracy = accuracy;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoCode geoCode = (GeoCode)o;
        return this.accuracy == geoCode.accuracy && Double.compare(geoCode.latitude, this.latitude) == 0 && Double.compare(geoCode.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        int result = this.accuracy;
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoCode{accuracy=" + this.accuracy + ", latitude=" + this.latitude + ", longitude=" + this.longitude + '}';
    }

    public int accuracy() {
        return this.accuracy;
    }

    public double latitude() {
        return this.latitude;
    }

    public double longitude() {
        return this.longitude;
    }
}

