/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.data.profile;

import com.squareup.moshi.Json;
import com.xing.api.data.SafeCalendar;
import com.xing.api.data.profile.CareerLevel;
import com.xing.api.data.profile.CompanySize;
import com.xing.api.data.profile.Discipline;
import com.xing.api.data.profile.FormOfEmployment;
import com.xing.api.data.profile.Industry;
import java.io.Serializable;
import java.util.List;

public class Company
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int LIMIT_DESCRIPTION = 512;
    static final int LIMIT_NAME = 80;
    static final int LIMIT_TITLE = 80;
    static final int LIMIT_URL = 128;
    @Json(name="id")
    private String id;
    @Json(name="name")
    private String name;
    @Json(name="title")
    private String title;
    @Json(name="company_size")
    private CompanySize companySize;
    @Json(name="tag")
    private String tag;
    @Json(name="url")
    private String url;
    @Json(name="career_level")
    private CareerLevel careerLevel;
    @Json(name="begin_date")
    private SafeCalendar beginDate;
    @Json(name="end_date")
    private SafeCalendar endDate;
    @Json(name="description")
    private String description;
    @Json(name="industries")
    private List<Industry> industries;
    @Json(name="form_of_employment")
    private FormOfEmployment formOfEmployment;
    @Json(name="until_now")
    private boolean untilNow;
    @Json(name="discipline")
    private Discipline discipline;

    static void throwIfArgumentToLong(String tag, String arg, int limit) {
        if (arg != null && arg.length() > limit) {
            throw new IllegalArgumentException(String.format("Argument %s too long. %d characters is the maximum.", tag, limit));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Company company = (Company)o;
        if (this.untilNow != company.untilNow) {
            return false;
        }
        if (this.id != null ? !this.id.equals(company.id) : company.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(company.name) : company.name != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(company.title) : company.title != null) {
            return false;
        }
        if (this.companySize != company.companySize) {
            return false;
        }
        if (this.tag != null ? !this.tag.equals(company.tag) : company.tag != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(company.url) : company.url != null) {
            return false;
        }
        if (this.careerLevel != company.careerLevel) {
            return false;
        }
        if (this.beginDate != null ? !this.beginDate.equals(company.beginDate) : company.beginDate != null) {
            return false;
        }
        if (this.endDate != null ? !this.endDate.equals(company.endDate) : company.endDate != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(company.description) : company.description != null) {
            return false;
        }
        if (this.industries != null ? !this.industries.equals(company.industries) : company.industries != null) {
            return false;
        }
        if (this.formOfEmployment != company.formOfEmployment) {
            return false;
        }
        return this.discipline != null ? this.discipline.equals(company.discipline) : company.discipline == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.companySize != null ? this.companySize.hashCode() : 0);
        result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.careerLevel != null ? this.careerLevel.hashCode() : 0);
        result = 31 * result + (this.beginDate != null ? this.beginDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.industries != null ? this.industries.hashCode() : 0);
        result = 31 * result + (this.formOfEmployment != null ? this.formOfEmployment.hashCode() : 0);
        result = 31 * result + (this.untilNow ? 1 : 0);
        result = 31 * result + (this.discipline != null ? this.discipline.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Company{id='" + this.id + '\'' + ", careerLevel=" + (Object)((Object)this.careerLevel) + ", companySize=" + (Object)((Object)this.companySize) + ", description='" + this.description + '\'' + ", formOfEmployment=" + (Object)((Object)this.formOfEmployment) + ", industries=" + this.industries + ", name='" + this.name + '\'' + ", title='" + this.title + '\'' + ", tag='" + this.tag + '\'' + ", untilNow=" + this.untilNow + ", url='" + this.url + '\'' + ", beginDate='" + this.beginDate + '\'' + ", endDate='" + this.endDate + '\'' + ", discipline='" + this.discipline + '\'' + '}';
    }

    public String id() {
        return this.id;
    }

    public Company id(String id) {
        this.id = id;
        return this;
    }

    public SafeCalendar beginDate() {
        return this.beginDate;
    }

    public Company beginDate(SafeCalendar beginDate) {
        this.beginDate = beginDate;
        return this;
    }

    public CareerLevel careerLevel() {
        return this.careerLevel;
    }

    public Company careerLevel(CareerLevel careerLevel) {
        this.careerLevel = careerLevel;
        return this;
    }

    public CompanySize companySize() {
        return this.companySize;
    }

    public Company companySize(CompanySize companySize) {
        this.companySize = companySize;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Company description(String description) {
        Company.throwIfArgumentToLong("Description", description, 512);
        this.description = description;
        return this;
    }

    public SafeCalendar endDate() {
        return this.endDate;
    }

    public Company endDate(SafeCalendar endDate) {
        this.endDate = endDate;
        return this;
    }

    public FormOfEmployment formOfEmployment() {
        return this.formOfEmployment;
    }

    public Company formOfEmployment(FormOfEmployment formOfEmployment) {
        this.formOfEmployment = formOfEmployment;
        return this;
    }

    public List<Industry> industries() {
        return this.industries;
    }

    public Company industries(List<Industry> industries) {
        this.industries = industries;
        return this;
    }

    public String name() {
        return this.name;
    }

    public Company name(String name) {
        Company.throwIfArgumentToLong("Name", name, 80);
        this.name = name;
        return this;
    }

    public String title() {
        return this.title;
    }

    public Company title(String title) {
        Company.throwIfArgumentToLong("Title", title, 80);
        this.title = title;
        return this;
    }

    public boolean untilNow() {
        return this.untilNow;
    }

    public Company untilNow(boolean untilNow) {
        this.untilNow = untilNow;
        return this;
    }

    public String url() {
        return this.url;
    }

    public Company url(String url) {
        Company.throwIfArgumentToLong("Url", url, 128);
        this.url = url;
        return this;
    }

    public String tag() {
        return this.tag;
    }

    public Company tag(String tag) {
        this.tag = tag;
        return this;
    }

    public Discipline discipline() {
        return this.discipline;
    }

    public Company discipline(Discipline discipline) {
        this.discipline = discipline;
        return this;
    }

    public boolean isFilledForAddCompany() {
        return this.name != null && !this.name.isEmpty() && this.title != null && !this.title.isEmpty() && this.industries != null && !this.industries.isEmpty() && this.formOfEmployment != null;
    }
}

