/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.data.profile;

import com.serjltt.moshi.adapters.FallbackOnNull;
import com.squareup.moshi.Json;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class Industry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final float FIRST_CATEGORY_CONVERSION = 10000.0f;
    @Json(name="id")
    @FallbackOnNull(fallbackInt=-1)
    private final int id;
    @Json(name="localized_name")
    private final String name;
    @Json(name="segments")
    private final List<Industry> segments;

    public static Industry newInstanceFromCompoundId(int compoundId) {
        Industry segment = new Industry(compoundId, "");
        return new Industry(Industry.extractFirstCategoryIndex(compoundId), "", Collections.singletonList(segment));
    }

    static int extractFirstCategoryIndex(int encodedId) {
        return (int)(Math.floor((float)encodedId / 10000.0f) * 10000.0);
    }

    public Industry(int id, String name) {
        this(id, name, null);
    }

    public Industry(int id, String name, List<Industry> segments) {
        this.id = id;
        this.name = name;
        this.segments = segments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Industry industry = (Industry)o;
        return this.id == industry.id && (this.name != null ? this.name.equals(industry.name) : industry.name == null) && (this.segments != null ? this.segments.equals(industry.segments) : industry.segments == null);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.segments != null ? this.segments.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Industry{id=" + this.id + ", name='" + this.name + '\'' + ", segments=" + this.segments + '}';
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public List<Industry> segments() {
        return this.segments;
    }
}

