/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.data.profile;

import com.squareup.moshi.Json;
import com.xing.api.data.SafeCalendar;
import com.xing.api.data.profile.Address;
import com.xing.api.data.profile.Badge;
import com.xing.api.data.profile.Company;
import com.xing.api.data.profile.EducationalBackground;
import com.xing.api.data.profile.EmploymentStatus;
import com.xing.api.data.profile.Gender;
import com.xing.api.data.profile.Language;
import com.xing.api.data.profile.LanguageSkill;
import com.xing.api.data.profile.LegalInformationPreview;
import com.xing.api.data.profile.MessagingAccount;
import com.xing.api.data.profile.PhotoUrls;
import com.xing.api.data.profile.PremiumService;
import com.xing.api.data.profile.ProfessionalExperience;
import com.xing.api.data.profile.School;
import com.xing.api.data.profile.TimeZone;
import com.xing.api.data.profile.WebProfile;
import com.xing.api.internal.json.BirthDate;
import com.xing.api.internal.json.CsvCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XingUser
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Json(name="id")
    private String id;
    @Json(name="academic_title")
    private String academicTitle;
    @Json(name="first_name")
    private String firstName;
    @Json(name="last_name")
    private String lastName;
    @Json(name="display_name")
    private String displayName;
    @Json(name="page_name")
    private String pageName;
    @Json(name="permalink")
    private String permalink;
    @Json(name="employment_status")
    private EmploymentStatus employmentStatus;
    @Json(name="gender")
    private Gender gender;
    @BirthDate
    @Json(name="birth_date")
    private SafeCalendar birthDate;
    @Json(name="active_email")
    private String activeEmail;
    @Json(name="time_zone")
    private TimeZone timeZone;
    @Json(name="premium_services")
    private List<PremiumService> premiumServices;
    @Json(name="badges")
    private List<Badge> badges;
    @CsvCollection
    @Json(name="wants")
    private List<String> wants;
    @CsvCollection
    @Json(name="haves")
    private List<String> haves;
    @CsvCollection
    @Json(name="top_haves")
    private List<String> topHaves;
    @CsvCollection
    @Json(name="interests")
    private List<String> interests;
    @CsvCollection
    @Json(name="organisation_member")
    private List<String> organizations;
    @Json(name="languages")
    private Map<Language, LanguageSkill> languages;
    @Json(name="private_address")
    private Address privateAddress;
    @Json(name="business_address")
    private Address businessAddress;
    @Json(name="web_profiles")
    private Map<WebProfile, Set<String>> webProfiles;
    @Json(name="instant_messaging_accounts")
    private Map<MessagingAccount, String> messagingAccounts;
    @Json(name="professional_experience")
    private ProfessionalExperience professionalExperience;
    @Json(name="educational_background")
    private EducationalBackground educationBackground;
    @Json(name="photo_urls")
    private PhotoUrls photoUrls;
    @Json(name="legal_information")
    private LegalInformationPreview legalInformationPreview;

    @Deprecated
    public XingUser() {
    }

    public XingUser(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XingUser xingUser = (XingUser)o;
        if (this.id != null ? !this.id.equals(xingUser.id) : xingUser.id != null) {
            return false;
        }
        if (this.academicTitle != null ? !this.academicTitle.equals(xingUser.academicTitle) : xingUser.academicTitle != null) {
            return false;
        }
        if (this.firstName != null ? !this.firstName.equals(xingUser.firstName) : xingUser.firstName != null) {
            return false;
        }
        if (this.lastName != null ? !this.lastName.equals(xingUser.lastName) : xingUser.lastName != null) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(xingUser.displayName) : xingUser.displayName != null) {
            return false;
        }
        if (this.pageName != null ? !this.pageName.equals(xingUser.pageName) : xingUser.pageName != null) {
            return false;
        }
        if (this.permalink != null ? !this.permalink.equals(xingUser.permalink) : xingUser.permalink != null) {
            return false;
        }
        if (this.employmentStatus != xingUser.employmentStatus) {
            return false;
        }
        if (this.gender != xingUser.gender) {
            return false;
        }
        if (this.birthDate != null ? !this.birthDate.equals(xingUser.birthDate) : xingUser.birthDate != null) {
            return false;
        }
        if (this.activeEmail != null ? !this.activeEmail.equals(xingUser.activeEmail) : xingUser.activeEmail != null) {
            return false;
        }
        if (this.timeZone != null ? !this.timeZone.equals(xingUser.timeZone) : xingUser.timeZone != null) {
            return false;
        }
        if (this.premiumServices != null ? !this.premiumServices.equals(xingUser.premiumServices) : xingUser.premiumServices != null) {
            return false;
        }
        if (this.badges != null ? !this.badges.equals(xingUser.badges) : xingUser.badges != null) {
            return false;
        }
        if (this.wants != null ? !this.wants.equals(xingUser.wants) : xingUser.wants != null) {
            return false;
        }
        if (this.haves != null ? !this.haves.equals(xingUser.haves) : xingUser.haves != null) {
            return false;
        }
        if (this.topHaves != null ? !this.topHaves.equals(xingUser.topHaves) : xingUser.topHaves != null) {
            return false;
        }
        if (this.interests != null ? !this.interests.equals(xingUser.interests) : xingUser.interests != null) {
            return false;
        }
        if (this.organizations != null ? !this.organizations.equals(xingUser.organizations) : xingUser.organizations != null) {
            return false;
        }
        if (this.languages != null ? !this.languages.equals(xingUser.languages) : xingUser.languages != null) {
            return false;
        }
        if (this.privateAddress != null ? !this.privateAddress.equals(xingUser.privateAddress) : xingUser.privateAddress != null) {
            return false;
        }
        if (this.businessAddress != null ? !this.businessAddress.equals(xingUser.businessAddress) : xingUser.businessAddress != null) {
            return false;
        }
        if (this.webProfiles != null ? !this.webProfiles.equals(xingUser.webProfiles) : xingUser.webProfiles != null) {
            return false;
        }
        if (this.messagingAccounts != null ? !this.messagingAccounts.equals(xingUser.messagingAccounts) : xingUser.messagingAccounts != null) {
            return false;
        }
        if (this.professionalExperience != null ? !this.professionalExperience.equals(xingUser.professionalExperience) : xingUser.professionalExperience != null) {
            return false;
        }
        if (this.educationBackground != null ? !this.educationBackground.equals(xingUser.educationBackground) : xingUser.educationBackground != null) {
            return false;
        }
        if (this.legalInformationPreview != null ? !this.legalInformationPreview.equals(xingUser.legalInformationPreview) : xingUser.legalInformationPreview != null) {
            return false;
        }
        return this.photoUrls != null ? this.photoUrls.equals(xingUser.photoUrls) : xingUser.photoUrls == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.academicTitle != null ? this.academicTitle.hashCode() : 0);
        result = 31 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
        result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + (this.pageName != null ? this.pageName.hashCode() : 0);
        result = 31 * result + (this.permalink != null ? this.permalink.hashCode() : 0);
        result = 31 * result + (this.employmentStatus != null ? this.employmentStatus.hashCode() : 0);
        result = 31 * result + (this.gender != null ? this.gender.hashCode() : 0);
        result = 31 * result + (this.birthDate != null ? this.birthDate.hashCode() : 0);
        result = 31 * result + (this.activeEmail != null ? this.activeEmail.hashCode() : 0);
        result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
        result = 31 * result + (this.premiumServices != null ? this.premiumServices.hashCode() : 0);
        result = 31 * result + (this.badges != null ? this.badges.hashCode() : 0);
        result = 31 * result + (this.wants != null ? this.wants.hashCode() : 0);
        result = 31 * result + (this.haves != null ? this.haves.hashCode() : 0);
        result = 31 * result + (this.topHaves != null ? this.topHaves.hashCode() : 0);
        result = 31 * result + (this.interests != null ? this.interests.hashCode() : 0);
        result = 31 * result + (this.organizations != null ? this.organizations.hashCode() : 0);
        result = 31 * result + (this.languages != null ? this.languages.hashCode() : 0);
        result = 31 * result + (this.privateAddress != null ? this.privateAddress.hashCode() : 0);
        result = 31 * result + (this.businessAddress != null ? this.businessAddress.hashCode() : 0);
        result = 31 * result + (this.webProfiles != null ? this.webProfiles.hashCode() : 0);
        result = 31 * result + (this.messagingAccounts != null ? this.messagingAccounts.hashCode() : 0);
        result = 31 * result + (this.professionalExperience != null ? this.professionalExperience.hashCode() : 0);
        result = 31 * result + (this.educationBackground != null ? this.educationBackground.hashCode() : 0);
        result = 31 * result + (this.photoUrls != null ? this.photoUrls.hashCode() : 0);
        result = 31 * result + (this.legalInformationPreview != null ? this.legalInformationPreview.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "XingUser{id='" + this.id + '\'' + ", academicTitle='" + this.academicTitle + '\'' + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", displayName='" + this.displayName + '\'' + ", pageName='" + this.pageName + '\'' + ", permalink=" + this.permalink + ", employmentStatus=" + (Object)((Object)this.employmentStatus) + ", gender=" + (Object)((Object)this.gender) + ", birthDate=" + this.birthDate + ", activeEmail='" + this.activeEmail + '\'' + ", premiumServices=" + this.premiumServices + ", badges=" + this.badges + ", wants=" + this.wants + ", haves=" + this.haves + ", topHaves=" + this.topHaves + ", interests=" + this.interests + ", organizations=" + this.organizations + ", languages=" + this.languages + ", privateAddress=" + this.privateAddress + ", timeZone=" + this.timeZone + ", businessAddress=" + this.businessAddress + ", webProfiles=" + this.webProfiles + ", messagingAccounts=" + this.messagingAccounts + ", educationBackground=" + this.educationBackground + ", professionalExperience=" + this.professionalExperience + ", photoUrls=" + this.photoUrls + ", legalInformationPreview=" + this.legalInformationPreview + '}';
    }

    public String id() {
        return this.id;
    }

    @Deprecated
    public XingUser id(String id) {
        this.id = id;
        return this;
    }

    public String academicTitle() {
        return this.academicTitle;
    }

    public XingUser academicTitle(String academicTitle) {
        this.academicTitle = academicTitle;
        return this;
    }

    public String firstName() {
        return this.firstName;
    }

    public XingUser firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String lastName() {
        return this.lastName;
    }

    public XingUser lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public XingUser displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Gender gender() {
        return this.gender;
    }

    public XingUser gender(Gender gender) {
        this.gender = gender;
        return this;
    }

    public String pageName() {
        return this.pageName;
    }

    public XingUser pageName(String pageName) {
        this.pageName = pageName;
        return this;
    }

    public String permalink() {
        return this.permalink;
    }

    public XingUser permalink(String permalink) {
        this.permalink = permalink;
        return this;
    }

    public EmploymentStatus employmentStatus() {
        return this.employmentStatus;
    }

    public XingUser employmentStatus(EmploymentStatus employmentStatus) {
        this.employmentStatus = employmentStatus;
        return this;
    }

    public SafeCalendar birthDate() {
        return this.birthDate;
    }

    public XingUser birthDate(SafeCalendar birthDate) {
        this.birthDate = birthDate;
        return this;
    }

    public String activeEmail() {
        return this.activeEmail;
    }

    public XingUser activeEmail(String activeEmail) {
        this.activeEmail = activeEmail;
        return this;
    }

    public List<PremiumService> premiumServices() {
        return this.premiumServices;
    }

    public XingUser premiumServices(List<PremiumService> premiumServices) {
        this.premiumServices = premiumServices;
        return this;
    }

    public XingUser addPremiumService(PremiumService premiumService) {
        if (this.premiumServices == null) {
            this.premiumServices = new ArrayList<PremiumService>(1);
        }
        this.premiumServices.add(premiumService);
        return this;
    }

    public List<Badge> badges() {
        return this.badges;
    }

    public XingUser badges(List<Badge> badges) {
        this.badges = badges;
        return this;
    }

    public XingUser addToBadges(Badge badge) {
        if (this.badges == null) {
            this.badges = new ArrayList<Badge>(1);
        }
        this.badges.add(badge);
        return this;
    }

    public XingUser addAllToBadges(List<Badge> badges) {
        if (this.badges == null) {
            this.badges = badges;
        } else {
            this.badges.addAll(badges);
        }
        return this;
    }

    public List<String> wants() {
        return this.wants;
    }

    public XingUser wants(List<String> wants) {
        this.wants = wants;
        return this;
    }

    public XingUser addToWants(String want) {
        if (this.wants == null) {
            this.wants = new ArrayList<String>(1);
        }
        this.wants.add(want);
        return this;
    }

    public XingUser addAllToWants(List<String> wants) {
        if (this.wants == null) {
            this.wants = wants;
        } else {
            this.wants.addAll(wants);
        }
        return this;
    }

    public List<String> haves() {
        return this.haves;
    }

    public XingUser haves(List<String> haves) {
        this.haves = haves;
        return this;
    }

    public XingUser addToHaves(String has) {
        if (this.haves == null) {
            this.haves = new ArrayList<String>(1);
        }
        this.haves.add(has);
        return this;
    }

    public XingUser addAllToHaves(List<String> haves) {
        if (this.haves == null) {
            this.haves = haves;
        } else {
            this.haves.addAll(haves);
        }
        return this;
    }

    public List<String> topHaves() {
        return this.topHaves;
    }

    public XingUser topHaves(List<String> topHaves) {
        this.topHaves = topHaves;
        return this;
    }

    public XingUser addToTopHaves(String has) {
        if (this.topHaves == null) {
            this.topHaves = new ArrayList<String>(1);
        }
        this.topHaves.add(has);
        return this;
    }

    public XingUser addAllToTopHaves(List<String> topHaves) {
        if (this.topHaves == null) {
            this.topHaves = topHaves;
        } else {
            this.topHaves.addAll(topHaves);
        }
        return this;
    }

    public List<String> interests() {
        return this.interests;
    }

    public XingUser interests(List<String> interests) {
        this.interests = interests;
        return this;
    }

    public XingUser addToInterests(String interest) {
        if (this.interests == null) {
            this.interests = new ArrayList<String>(1);
        }
        this.interests.add(interest);
        return this;
    }

    public XingUser addAllToInterests(List<String> interests) {
        if (this.interests == null) {
            this.interests = interests;
        } else {
            this.interests.addAll(interests);
        }
        return this;
    }

    public List<String> organizations() {
        return this.organizations;
    }

    public XingUser organizations(List<String> organizations) {
        this.organizations = organizations;
        return this;
    }

    public XingUser addToOrganisations(String organization) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>(1);
        }
        this.organizations.add(organization);
        return this;
    }

    public XingUser addAllToOrganizations(List<String> organizations) {
        if (this.organizations == null) {
            this.organizations = organizations;
        } else {
            this.organizations.addAll(organizations);
        }
        return this;
    }

    public Map<Language, LanguageSkill> languages() {
        return this.languages;
    }

    public XingUser languages(Map<Language, LanguageSkill> languages) {
        this.languages = languages;
        return this;
    }

    public LanguageSkill languageSkill(Language language) {
        return this.languages.get((Object)language);
    }

    public XingUser addLanguage(Language language, LanguageSkill languageSkill) {
        if (this.languages == null) {
            this.languages = new LinkedHashMap<Language, LanguageSkill>();
        }
        this.languages.put(language, languageSkill);
        return this;
    }

    public Address privateAddress() {
        return this.privateAddress;
    }

    public XingUser privateAddress(Address privateAddress) {
        this.privateAddress = privateAddress;
        return this;
    }

    public Address businessAddress() {
        return this.businessAddress;
    }

    public XingUser businessAddress(Address businessAddress) {
        this.businessAddress = businessAddress;
        return this;
    }

    public Map<WebProfile, Set<String>> webProfiles() {
        return this.webProfiles;
    }

    public XingUser webProfiles(Map<WebProfile, Set<String>> webProfiles) {
        this.webProfiles = webProfiles;
        return this;
    }

    public XingUser webProfiles(WebProfile webProfile, Set<String> profiles) {
        if (this.webProfiles == null) {
            this.webProfiles = new LinkedHashMap<WebProfile, Set<String>>();
        }
        this.webProfiles.put(webProfile, profiles);
        return this;
    }

    public XingUser addToWebProfile(WebProfile webProfile, String accountName) {
        if (this.webProfiles == null) {
            this.webProfiles = new LinkedHashMap<WebProfile, Set<String>>();
        }
        if (!this.webProfiles.containsKey((Object)webProfile)) {
            this.webProfiles.put(webProfile, new LinkedHashSet());
        }
        this.webProfiles.get((Object)webProfile).add(accountName);
        return this;
    }

    public XingUser addAllToWebProfile(WebProfile webProfile, Set<String> profiles) {
        if (this.webProfiles == null) {
            this.webProfiles = new LinkedHashMap<WebProfile, Set<String>>();
        }
        if (!this.webProfiles.containsKey((Object)webProfile)) {
            this.webProfiles.put(webProfile, new LinkedHashSet());
        }
        if (profiles != null) {
            this.webProfiles.get((Object)webProfile).addAll(profiles);
        }
        return this;
    }

    public EducationalBackground educationBackground() {
        return this.educationBackground;
    }

    public XingUser educationBackground(EducationalBackground educationBackground) {
        this.educationBackground = educationBackground;
        return this;
    }

    public PhotoUrls photoUrls() {
        return this.photoUrls;
    }

    public XingUser photoUrls(PhotoUrls photoUrls) {
        this.photoUrls = photoUrls;
        return this;
    }

    public TimeZone timeZone() {
        return this.timeZone;
    }

    public XingUser timeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public Map<MessagingAccount, String> messagingAccounts() {
        return this.messagingAccounts;
    }

    public XingUser messagingAccounts(Map<MessagingAccount, String> messagingAccounts) {
        this.messagingAccounts = messagingAccounts;
        return this;
    }

    public XingUser addMessagingAccount(MessagingAccount account, String accountValue) {
        if (this.messagingAccounts == null) {
            this.messagingAccounts = new LinkedHashMap<MessagingAccount, String>();
        }
        this.messagingAccounts.put(account, accountValue);
        return this;
    }

    public ProfessionalExperience professionalExperience() {
        return this.professionalExperience;
    }

    public XingUser professionalExperience(ProfessionalExperience professionalExperience) {
        this.professionalExperience = professionalExperience;
        return this;
    }

    public LegalInformationPreview legalInformationPreview() {
        return this.legalInformationPreview;
    }

    public XingUser legalInformationPreview(LegalInformationPreview legalInformationPreview) {
        this.legalInformationPreview = legalInformationPreview;
        return this;
    }

    public String primaryInstitutionName() {
        String primaryInstitution = null;
        if (this.professionalExperience != null && this.professionalExperience.primaryCompany() != null) {
            Company company = this.professionalExperience.primaryCompany();
            primaryInstitution = company.name();
        }
        if ((primaryInstitution == null || primaryInstitution.isEmpty()) && this.educationBackground != null && this.educationBackground.primarySchool() != null) {
            School primarySchool = this.educationBackground.primarySchool();
            primaryInstitution = primarySchool.name();
        }
        return primaryInstitution;
    }

    public String primaryOccupationName() {
        String primaryOccupation = null;
        if (this.professionalExperience != null && this.professionalExperience.primaryCompany() != null) {
            Company company = this.professionalExperience.primaryCompany();
            primaryOccupation = company.title();
        }
        if ((primaryOccupation == null || primaryOccupation.isEmpty()) && this.educationBackground != null && this.educationBackground.primarySchool() != null) {
            School primarySchool = this.educationBackground.primarySchool();
            primaryOccupation = primarySchool.degree();
        }
        return primaryOccupation;
    }

    public boolean isPremium() {
        return this.premiumServices != null && !this.premiumServices.isEmpty();
    }

    public boolean isBlacklisted() {
        return this.id == null || this.id.isEmpty();
    }
}

