/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.internal.json;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.xing.api.data.SafeCalendar;
import com.xing.api.internal.json.BirthDate;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;

public final class BirthDateJsonAdapter
extends JsonAdapter<SafeCalendar> {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            if (annotations.isEmpty() || annotations.size() != 1 || annotations.iterator().next().annotationType() != BirthDate.class) {
                return null;
            }
            Class rawType = Types.getRawType((Type)type);
            if (rawType != SafeCalendar.class) {
                return null;
            }
            return new BirthDateJsonAdapter().nullSafe();
        }
    };

    BirthDateJsonAdapter() {
    }

    public SafeCalendar fromJson(JsonReader reader) throws IOException {
        SafeCalendar calendar = new SafeCalendar();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (reader.peek() == JsonReader.Token.NULL) {
                reader.skipValue();
                continue;
            }
            if ("year".equals(name)) {
                calendar.set(1, reader.nextInt());
                continue;
            }
            if ("month".equals(name)) {
                calendar.set(2, reader.nextInt() - 1);
                continue;
            }
            if ("day".equals(name)) {
                calendar.set(5, reader.nextInt());
                continue;
            }
            throw new IOException("birthday should contain 'year', 'month' and/or 'day', found $" + name);
        }
        reader.endObject();
        return calendar;
    }

    public void toJson(JsonWriter writer, SafeCalendar value) throws IOException {
        writer.setSerializeNulls(true);
        writer.beginObject();
        BirthDateJsonAdapter.writeValueOrNull(writer, value, "year", 1);
        BirthDateJsonAdapter.writeValueOrNull(writer, value, "month", 2);
        BirthDateJsonAdapter.writeValueOrNull(writer, value, "day", 5);
        writer.endObject();
        writer.setSerializeNulls(false);
    }

    private static void writeValueOrNull(JsonWriter writer, SafeCalendar calendar, String name, int field) throws IOException {
        writer.name(name);
        if (calendar.isSet(field)) {
            int value = calendar.get(field);
            writer.value(field == 2 ? (long)(value + 1) : (long)value);
        } else {
            writer.nullValue();
        }
    }
}

