/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.internal.json;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.xing.api.internal.json.CsvCollection;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class CsvCollectionJsonAdapter<C extends Collection<String>>
extends JsonAdapter<C> {
    private static final String COMMA_DELIMITER = ",";
    private static final Pattern COMMA_SEPARATOR = Pattern.compile(",");
    private static final String COMMA_SPACE_DELIMITER = ", ";
    private static final Pattern COMMA_SPACE_SEPARATOR = Pattern.compile(", ");
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            if (annotations.isEmpty() || annotations.size() != 1 || annotations.iterator().next().annotationType() != CsvCollection.class) {
                return null;
            }
            Class rawType = Types.getRawType((Type)type);
            if ((rawType == List.class || rawType == Collection.class) && this.elementTypeIsString(type)) {
                return CsvCollectionJsonAdapter.newArrayListStringAdapter().nullSafe();
            }
            if (rawType == Set.class && this.elementTypeIsString(type)) {
                return CsvCollectionJsonAdapter.newLinkedHashSetStringAdapter().nullSafe();
            }
            return null;
        }

        boolean elementTypeIsString(Type type) {
            Type elementType = Types.collectionElementType((Type)type, Collection.class);
            Class rawElementType = Types.getRawType((Type)elementType);
            return rawElementType == String.class;
        }
    };

    static JsonAdapter<Collection<String>> newArrayListStringAdapter() {
        return new CsvCollectionJsonAdapter<Collection<String>>(){

            @Override
            Collection<String> newCollection() {
                return new ArrayList<String>();
            }
        };
    }

    static JsonAdapter<Set<String>> newLinkedHashSetStringAdapter() {
        return new CsvCollectionJsonAdapter<Set<String>>(){

            @Override
            Set<String> newCollection() {
                return new LinkedHashSet<String>();
            }
        };
    }

    CsvCollectionJsonAdapter() {
    }

    public C fromJson(JsonReader reader) throws IOException {
        C result = this.newCollection();
        String csString = reader.nextString();
        String removeSpaces = COMMA_SPACE_SEPARATOR.matcher(csString).replaceAll(COMMA_DELIMITER);
        String[] strings = COMMA_SEPARATOR.split(removeSpaces);
        int size = strings.length;
        for (int index = 0; index < size; ++index) {
            result.add((String)strings[index]);
        }
        return result;
    }

    public void toJson(JsonWriter writer, C value) throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (String token : value) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(COMMA_SPACE_DELIMITER);
            }
            sb.append(token);
        }
        writer.value(sb.toString());
    }

    abstract C newCollection();

    public String toString() {
        return "JsonAdapter(String).csvCollection()";
    }
}

