/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.internal.json;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.xing.api.data.GeoCode;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;

public final class GeoCodeJsonAdapter
extends JsonAdapter<GeoCode> {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            if (!annotations.isEmpty()) {
                return null;
            }
            Class rawType = Types.getRawType((Type)type);
            if (rawType != GeoCode.class) {
                return null;
            }
            return new GeoCodeJsonAdapter().nullSafe();
        }
    };

    GeoCodeJsonAdapter() {
    }

    public GeoCode fromJson(JsonReader reader) throws IOException {
        Double latitude = null;
        Double longitude = null;
        int accuracy = 0;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (reader.peek() == JsonReader.Token.NULL) {
                reader.skipValue();
                continue;
            }
            if ("accuracy".equals(name)) {
                accuracy = reader.nextInt();
                continue;
            }
            if ("latitude".equals(name)) {
                latitude = reader.nextDouble();
                continue;
            }
            if ("longitude".equals(name)) {
                longitude = reader.nextDouble();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (latitude == null || longitude == null) {
            return null;
        }
        return new GeoCode(accuracy, latitude, longitude);
    }

    public void toJson(JsonWriter writer, GeoCode geoCode) throws IOException {
        writer.beginObject();
        writer.name("accuracy").value((long)geoCode.accuracy());
        writer.name("latitude").value(geoCode.latitude());
        writer.name("longitude").value(geoCode.longitude());
        writer.endObject();
    }

    public String toString() {
        return "JsonAdapter(GeoCode)";
    }
}

