/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.internal.json;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.xing.api.data.SafeCalendar;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SafeCalendarJsonAdapter<T extends Calendar>
extends JsonAdapter<T> {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            if (!annotations.isEmpty()) {
                return null;
            }
            Class rawType = Types.getRawType((Type)type);
            if (rawType == SafeCalendar.class || rawType == GregorianCalendar.class || rawType == Calendar.class) {
                return new SafeCalendarJsonAdapter().nullSafe();
            }
            return null;
        }
    };
    static final TimeZone ZULU_TIME_ZONE = TimeZone.getTimeZone("UTC");
    static final Pattern REG_EX_YEAR = Pattern.compile("^(19|20)\\d{2}");
    private static final Pattern REG_EX_YEAR_MONTH = Pattern.compile("^(19|20)\\d{2}-\\d{2}$");
    private static final Pattern REG_EX_MONTH_DAY = Pattern.compile("\\d{2}-\\d{2}$");
    private static final Pattern REG_EX_YEAR_MONTH_DAY = Pattern.compile("^(19|20)\\d{2}-\\d{2}-\\d{2}$");
    private static final Pattern REG_EX_ISO_DATE_Z = Pattern.compile("^(19|20)\\d{2}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z$");
    private static final Pattern REG_EX_ISO_DATE_TIME = Pattern.compile("^(19|20)\\d{2}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[+]\\d{4}$");
    private static final Pattern REG_EX_THREE_LETTER_ISO8601_DATE_FORMAT = Pattern.compile("^(19|20)\\d{2}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[+|-]\\d{2}:\\d{2}$");
    private static final Pattern REG_EX_ISO_DATE_WEIRD = Pattern.compile("^(19|20)\\d{2}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d{3}Z$");
    private static final Pattern REG_EX_ISO_DATE_WEIRD_AND_ZONE = Pattern.compile("^(19|20)\\d{2}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d{3}[+|-]\\d{2}:\\d{2}$");
    private static final String ISO_DATE_FORMAT_Z = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String ISO_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String YEAR_DATE_FORMAT = "yyyy";
    private static final String YEAR_MONTH_DATE_FORMAT = "yyyy-MM";
    private static final String MONTH_DAY_DATE_FORMAT = "MM-dd";
    private static final String YEAR_MONTH_DAY_DATE_FORMAT = "yyyy-MM-dd";
    private static final String ISO_DATE_FORMAT_WEIRD = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String ISO_DATE_FORMAT_WEIRD_AND_ZONE = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final NumberFormat TWO_DIGITS_FORMATTER = new DecimalFormat("00");
    static final Map<Pattern, ThreadLocal<SimpleDateFormat>> DATE_FORMAT_MAP = new LinkedHashMap<Pattern, ThreadLocal<SimpleDateFormat>>(5);

    SafeCalendarJsonAdapter() {
    }

    public static void resolveTimeZone(Calendar calendar, String chosenPattern) {
        boolean isZuluTimeZone;
        boolean bl = isZuluTimeZone = ISO_DATE_FORMAT_Z.equals(chosenPattern) || ISO_DATE_FORMAT_WEIRD.equals(chosenPattern);
        if (!isZuluTimeZone) {
            return;
        }
        calendar.setTimeZone(ZULU_TIME_ZONE);
    }

    private static void clearCalendarByRegEx(Calendar calendar, String regEx) {
        switch (regEx) {
            case "yyyy": {
                calendar.clear(2);
                calendar.clear(5);
                SafeCalendarJsonAdapter.clearTime(calendar);
                break;
            }
            case "yyyy-MM": {
                calendar.clear(5);
                SafeCalendarJsonAdapter.clearTime(calendar);
                break;
            }
            case "MM-dd": {
                calendar.clear(1);
                SafeCalendarJsonAdapter.clearTime(calendar);
                break;
            }
            case "yyyy-MM-dd": {
                SafeCalendarJsonAdapter.clearTime(calendar);
            }
        }
    }

    private static void clearTime(Calendar calendar) {
        calendar.clear(10);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
    }

    private static boolean isFilledToTime(Calendar calendar) {
        return calendar.isSet(11) && calendar.isSet(12) && calendar.isSet(13);
    }

    public T fromJson(JsonReader reader) throws IOException {
        String dateStr = reader.nextString();
        if (dateStr.isEmpty()) {
            return null;
        }
        DateFormat format = null;
        for (Map.Entry<Pattern, ThreadLocal<SimpleDateFormat>> entry : DATE_FORMAT_MAP.entrySet()) {
            Matcher matcher = entry.getKey().matcher(dateStr);
            if (!matcher.matches()) continue;
            format = entry.getValue().get();
            break;
        }
        if (format == null) {
            throw new AssertionError((Object)("Unsupported date format! Expecting ISO 8601, but found: " + dateStr));
        }
        try {
            Date date = format.parse(dateStr);
            String chosenPattern = ((SimpleDateFormat)format).toPattern();
            SafeCalendar calendar = new SafeCalendar();
            SafeCalendarJsonAdapter.resolveTimeZone(calendar, chosenPattern);
            calendar.clear();
            calendar.setTime(date);
            SafeCalendarJsonAdapter.clearCalendarByRegEx(calendar, chosenPattern);
            return (T)calendar;
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public void toJson(JsonWriter writer, T calendar) throws IOException {
        StringBuilder output = new StringBuilder();
        if (((Calendar)calendar).isSet(1)) {
            output.append(((Calendar)calendar).get(1));
        }
        if (((Calendar)calendar).isSet(2)) {
            if (((Calendar)calendar).isSet(1)) {
                output.append('-');
            }
            output.append(TWO_DIGITS_FORMATTER.format(((Calendar)calendar).get(2) + 1));
            if (((Calendar)calendar).isSet(5)) {
                output.append('-');
                output.append(TWO_DIGITS_FORMATTER.format(((Calendar)calendar).get(5)));
                if (SafeCalendarJsonAdapter.isFilledToTime(calendar)) {
                    output.append('T');
                    output.append(TWO_DIGITS_FORMATTER.format(((Calendar)calendar).get(11)));
                    output.append(':');
                    output.append(TWO_DIGITS_FORMATTER.format(((Calendar)calendar).get(12)));
                    output.append(':');
                    output.append(TWO_DIGITS_FORMATTER.format(((Calendar)calendar).get(13)));
                    if (ZULU_TIME_ZONE.equals(((Calendar)calendar).getTimeZone())) {
                        output.append('Z');
                    } else {
                        TimeZone timeZone = ((Calendar)calendar).getTimeZone();
                        long millisWithOffset = timeZone.getOffset(((Calendar)calendar).getTimeInMillis());
                        String offset = String.format("%02d:%02d", Math.abs(millisWithOffset / 3600000L), Math.abs(millisWithOffset / 60000L % 60L));
                        output.append(millisWithOffset >= 0L ? "+" : "-").append(offset);
                    }
                }
            }
        }
        writer.value(output.length() > 0 ? output.toString() : null);
    }

    public String toString() {
        return "JsonAdapter(" + SafeCalendar.class + ')';
    }

    static {
        DATE_FORMAT_MAP.put(REG_EX_YEAR, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(SafeCalendarJsonAdapter.YEAR_DATE_FORMAT, Locale.ENGLISH);
            }
        });
        DATE_FORMAT_MAP.put(REG_EX_YEAR_MONTH, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(SafeCalendarJsonAdapter.YEAR_MONTH_DATE_FORMAT, Locale.ENGLISH);
            }
        });
        DATE_FORMAT_MAP.put(REG_EX_MONTH_DAY, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(SafeCalendarJsonAdapter.MONTH_DAY_DATE_FORMAT, Locale.ENGLISH);
            }
        });
        DATE_FORMAT_MAP.put(REG_EX_YEAR_MONTH_DAY, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(SafeCalendarJsonAdapter.YEAR_MONTH_DAY_DATE_FORMAT, Locale.ENGLISH);
            }
        });
        DATE_FORMAT_MAP.put(REG_EX_ISO_DATE_Z, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new ZuluDateFormat(SafeCalendarJsonAdapter.ISO_DATE_FORMAT_Z, Locale.ENGLISH);
            }
        });
        DATE_FORMAT_MAP.put(REG_EX_ISO_DATE_TIME, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(SafeCalendarJsonAdapter.ISO_DATE_FORMAT, Locale.ENGLISH);
            }
        });
        DATE_FORMAT_MAP.put(REG_EX_THREE_LETTER_ISO8601_DATE_FORMAT, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new ThreeLetterDateFormat(SafeCalendarJsonAdapter.ISO_DATE_FORMAT, Locale.ENGLISH);
            }
        });
        DATE_FORMAT_MAP.put(REG_EX_ISO_DATE_WEIRD, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new ZuluDateFormat(SafeCalendarJsonAdapter.ISO_DATE_FORMAT_WEIRD, Locale.ENGLISH);
            }
        });
        DATE_FORMAT_MAP.put(REG_EX_ISO_DATE_WEIRD_AND_ZONE, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(SafeCalendarJsonAdapter.ISO_DATE_FORMAT_WEIRD_AND_ZONE, Locale.ENGLISH);
            }
        });
    }

    static class ZuluDateFormat
    extends SimpleDateFormat {
        public ZuluDateFormat(String isoDateFormat, Locale locale) {
            super(isoDateFormat, locale);
            this.setTimeZone(ZULU_TIME_ZONE);
        }
    }

    static class ThreeLetterDateFormat
    extends SimpleDateFormat {
        public ThreeLetterDateFormat(String isoDateFormat, Locale locale) {
            super(isoDateFormat, locale);
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
            StringBuffer dateString = super.format(date, toAppendTo, pos);
            return dateString.insert(dateString.length() - 2, ':');
        }

        @Override
        public Date parse(String text, ParsePosition pos) {
            int index = text.length() - 3;
            text = text.substring(0, index) + text.substring(index + 1);
            return super.parse(text, pos);
        }
    }
}

