/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.internal.json;

import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class SafeEnumJsonAdapter<T extends Enum<T>>
extends JsonAdapter<T> {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            if (!annotations.isEmpty()) {
                return null;
            }
            Class rawType = Types.getRawType((Type)type);
            if (rawType.isEnum()) {
                return new SafeEnumJsonAdapter(rawType).nullSafe();
            }
            return null;
        }
    };
    private final Class<T> enumType;
    private final Map<String, T> nameConstantMap;
    private final String[] nameStrings;

    SafeEnumJsonAdapter(Class<T> enumType) {
        this.enumType = enumType;
        try {
            Enum[] constants = (Enum[])enumType.getEnumConstants();
            this.nameConstantMap = new LinkedHashMap<String, T>();
            this.nameStrings = new String[constants.length];
            for (Enum constant : constants) {
                Json annotation = enumType.getField(constant.name()).getAnnotation(Json.class);
                String name = annotation != null ? annotation.name() : constant.name();
                this.nameConstantMap.put(name, constant);
                this.nameStrings[i] = name;
            }
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError("Missing field in " + enumType.getName(), e);
        }
    }

    public T fromJson(JsonReader reader) throws IOException {
        String name = reader.nextString();
        return (T)((Enum)this.nameConstantMap.get(name));
    }

    public void toJson(JsonWriter writer, T value) throws IOException {
        writer.value(this.nameStrings[((Enum)value).ordinal()]);
    }

    public String toString() {
        return "SafeEnumJsonAdapter(" + this.enumType.getName() + ')';
    }
}

