/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.internal.json;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.xing.api.data.profile.TimeZone;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;

public final class TimeZoneJsonAdapter
extends JsonAdapter<TimeZone> {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            if (!annotations.isEmpty()) {
                return null;
            }
            Class rawType = Types.getRawType((Type)type);
            if (rawType != TimeZone.class) {
                return null;
            }
            return new TimeZoneJsonAdapter().nullSafe();
        }
    };

    TimeZoneJsonAdapter() {
    }

    public TimeZone fromJson(JsonReader reader) throws IOException {
        String timeZoneName = null;
        Double utcOffset = null;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (reader.peek() == JsonReader.Token.NULL) {
                reader.skipValue();
                continue;
            }
            if ("name".equals(name)) {
                timeZoneName = reader.nextString();
                continue;
            }
            if ("utc_offset".equals(name)) {
                utcOffset = reader.nextDouble();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (timeZoneName != null && utcOffset != null) {
            return new TimeZone(timeZoneName, utcOffset);
        }
        return null;
    }

    public void toJson(JsonWriter writer, TimeZone timeZone) throws IOException {
        writer.beginObject();
        writer.name("name").value(timeZone.name());
        writer.name("utc_offset").value(timeZone.utcOffset());
        writer.endObject();
    }

    public String toString() {
        return "JsonAdapter(TimeZone)";
    }
}

