/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.resources;

import com.xing.api.CallSpec;
import com.xing.api.HttpError;
import com.xing.api.Resource;
import com.xing.api.XingApi;
import com.xing.api.data.profile.Bookmark;
import java.util.List;

public class BookmarksResource
extends Resource {
    public static final Resource.Factory FACTORY = new Resource.Factory(BookmarksResource.class){

        @Override
        public Resource create(XingApi api) {
            return new BookmarksResource(api);
        }
    };

    BookmarksResource(XingApi api) {
        super(api);
    }

    public CallSpec<List<Bookmark>, HttpError> getListOfOwnBookmarks() {
        return Resource.newGetSpec(this.api, "/v1/users/me/bookmarks").responseAs(BookmarksResource.list(Bookmark.class, new String[]{"bookmarks", "items"})).build();
    }

    public CallSpec<Void, HttpError> createOwnBookmark(String userId) {
        return Resource.newPutSpec(this.api, "/v1/users/me/bookmarks/{id}", false).responseAs(Void.class).pathParam("id", userId).build();
    }

    public CallSpec<Void, HttpError> deleteOwnBookmark(String userId) {
        return Resource.newDeleteSpec(this.api, "/v1/users/me/bookmarks/{id}", false).responseAs(Void.class).pathParam("id", userId).build();
    }
}

