/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.resources;

import com.xing.api.CallSpec;
import com.xing.api.HttpError;
import com.xing.api.Resource;
import com.xing.api.XingApi;
import com.xing.api.data.contact.ContactPaths;
import com.xing.api.data.contact.ContactRequest;
import com.xing.api.data.contact.InvitationStats;
import com.xing.api.data.contact.PendingContactRequest;
import com.xing.api.data.profile.XingUser;
import com.xing.api.internal.Experimental;
import java.util.List;

public class ContactsResource
extends Resource {
    public static final Resource.Factory FACTORY = new Resource.Factory(ContactsResource.class){

        @Override
        public Resource create(XingApi api) {
            return new ContactsResource(api);
        }
    };

    ContactsResource(XingApi api) {
        super(api);
    }

    public CallSpec<List<XingUser>, HttpError> getUserContacts(String userId) {
        return Resource.newGetSpec(this.api, "/v1/users/{user_id}/contacts").pathParam("user_id", userId).responseAs(ContactsResource.list(XingUser.class, new String[]{"contacts", "users"})).build();
    }

    public CallSpec<List<XingUser>, HttpError> getOwnContacts() {
        return this.getUserContacts("me");
    }

    public CallSpec<List<String>, HttpError> getOwnContactsIds() {
        return Resource.newGetSpec(this.api, "/v1/users/me/contact_ids").responseAs(ContactsResource.list(String.class, new String[]{"contact_ids", "items"})).build();
    }

    public CallSpec<List<String>, HttpError> getAssignedTags(String userId, String contactId) {
        return Resource.newGetSpec(this.api, "/v1/users/{user_id}/contacts/{contact_id}/tags").pathParam("user_id", userId).pathParam("contact_id", contactId).responseAs(ContactsResource.list(ContactsResource.single(String.class, new String[]{"tag"}), "tags", "items")).build();
    }

    public CallSpec<List<String>, HttpError> getOwnAssignedTags(String contactId) {
        return this.getAssignedTags("me", contactId);
    }

    public CallSpec<List<XingUser>, HttpError> getSharedContacts(String userId) {
        return Resource.newGetSpec(this.api, "/v1/users/{user_id}/contacts/shared").pathParam("user_id", userId).responseAs(ContactsResource.list(XingUser.class, new String[]{"shared_contacts", "users"})).build();
    }

    @Experimental
    public CallSpec<List<XingUser>, HttpError> getUpcomingBirthdays() {
        return Resource.newGetSpec(this.api, "/v1/users/me/contacts/upcoming_birthdays").responseAs(ContactsResource.list(XingUser.class, new String[]{"users"})).build();
    }

    public CallSpec<List<ContactRequest>, HttpError> getIncomingContactRequests() {
        return Resource.newGetSpec(this.api, "/v1/users/me/contact_requests").responseAs(ContactsResource.list(ContactRequest.class, new String[]{"contact_requests"})).build();
    }

    public CallSpec<List<PendingContactRequest>, HttpError> getPendingContactRequests() {
        return Resource.newGetSpec(this.api, " /v1/users/me/contact_requests/sent").responseAs(ContactsResource.list(PendingContactRequest.class, new String[]{"contact_requests"})).build();
    }

    public CallSpec<Void, HttpError> sendContactRequest(String userId) {
        return Resource.newPostSpec(this.api, "/v1/users/{user_id}/contact_requests", false).pathParam("user_id", userId).responseAs(Void.class).build();
    }

    public CallSpec<Void, HttpError> acceptContactRequest(String recipientId, String senderId) {
        return Resource.newPutSpec(this.api, "/v1/users/{user_id}/contact_requests/{sender_id}/accept", false).pathParam("user_id", recipientId).pathParam("sender_id", senderId).responseAs(Void.class).build();
    }

    public CallSpec<Void, HttpError> revokeContactRequest(String recipientId, String senderId) {
        return Resource.newDeleteSpec(this.api, "/v1/users/{user_id}/contact_requests/{sender_id}", false).pathParam("user_id", recipientId).pathParam("sender_id", senderId).responseAs(Void.class).build();
    }

    public CallSpec<ContactPaths, HttpError> getContactPaths(String userId, String otherUserId) {
        return Resource.newGetSpec(this.api, "/v1/users/{user_id}/network/{other_user_id}/paths").pathParam("user_id", userId).pathParam("other_user_id", otherUserId).responseAs(ContactsResource.single(ContactPaths.class, new String[]{"contact_paths"})).build();
    }

    public CallSpec<InvitationStats, HttpError> inviteByMail(String ... emails) {
        return Resource.newPostSpec(this.api, "/v1/users/invite", true).queryParam("to_emails", emails).responseAs(ContactsResource.single(InvitationStats.class, new String[]{"invitation_stats"})).build();
    }
}

