/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.resources;

import com.xing.api.CallSpec;
import com.xing.api.HttpError;
import com.xing.api.Resource;
import com.xing.api.XingApi;
import com.xing.api.data.groups.Comment;
import com.xing.api.data.groups.Forum;
import com.xing.api.data.groups.Group;
import com.xing.api.data.groups.MediaPreview;
import com.xing.api.data.groups.Membership;
import com.xing.api.data.groups.Post;
import com.xing.api.data.profile.XingUser;
import com.xing.api.internal.Experimental;
import java.util.List;

public class GroupsResource
extends Resource {
    public static final Resource.Factory FACTORY = new Resource.Factory(GroupsResource.class){

        @Override
        public Resource create(XingApi api) {
            return new GroupsResource(api);
        }
    };

    protected GroupsResource(XingApi api) {
        super(api);
    }

    public CallSpec<List<Group>, HttpError> getUsersGroups(String userId) {
        return Resource.newGetSpec(this.api, "/v1/users/{user_id}/groups").responseAs(GroupsResource.list(Group.class, new String[]{"groups", "items"})).pathParam("user_id", userId).build();
    }

    public CallSpec<List<Group>, HttpError> getOwnGroups() {
        return this.getUsersGroups("me");
    }

    @Experimental
    public CallSpec<List<Group>, HttpError> findGroupByKeyword(String keywords) {
        return Resource.newGetSpec(this.api, "/v1/groups/find").responseAs(GroupsResource.list(GroupsResource.single(Group.class, new String[]{"group"}), "groups", "items")).queryParam("keywords", (Object)keywords).build();
    }

    public CallSpec<List<Forum>, HttpError> getForumsOfGroup(String groupId) {
        return Resource.newGetSpec(this.api, "/v1/groups/{group_id}/forums").responseAs(GroupsResource.list(Forum.class, new String[]{"forums", "items"})).pathParam("group_id", groupId).build();
    }

    public CallSpec<List<Post>, HttpError> getPostsOfForum(String forumId) {
        return Resource.newGetSpec(this.api, "/v1/groups/forums/{forum_id}/posts").responseAs(GroupsResource.list(Post.class, new String[]{"posts", "items"})).pathParam("forum_id", forumId).build();
    }

    public CallSpec<Post, HttpError> getPostInGroup(String postId) {
        return Resource.newGetSpec(this.api, "/v1/groups/forums/posts/{post_id}").responseAs(GroupsResource.single(Post.class, new String[]{"post"})).pathParam("post_id", postId).build();
    }

    public CallSpec<List<Post>, HttpError> getAllPostsOfGroup(String groupId) {
        return Resource.newGetSpec(this.api, "/v1/groups/{group_id}/posts").responseAs(GroupsResource.list(Post.class, new String[]{"posts", "items"})).pathParam("group_id", groupId).build();
    }

    public CallSpec<List<XingUser>, HttpError> getLikersOfPost(String postId) {
        return Resource.newGetSpec(this.api, "/v1/groups/forums/posts/{post_id}").responseAs(GroupsResource.list(XingUser.class, new String[]{"likes", "users"})).pathParam("post_id", postId).build();
    }

    public CallSpec<Void, HttpError> likePost(String postId) {
        return Resource.newPutSpec(this.api, "/v1/groups/forums/posts/{post_id}/like", false).responseAs(Void.class).pathParam("post_id", postId).build();
    }

    public CallSpec<Void, HttpError> unlikePost(String postId) {
        return Resource.newDeleteSpec(this.api, "/v1/groups/forums/posts/{post_id}/like", false).responseAs(Void.class).pathParam("post_id", postId).build();
    }

    public CallSpec<List<Comment>, HttpError> getCommentsOfPost(String postId) {
        return Resource.newGetSpec(this.api, "/v1/groups/forums/posts/{post_id}/comments").responseAs(GroupsResource.list(Comment.class, new String[]{"comments", "items"})).pathParam("post_id", postId).build();
    }

    public CallSpec<Void, HttpError> addCommentToPost(String content, String postId) {
        return Resource.newPostSpec(this.api, "/v1/groups/forums/posts/{post_id}/comments", false).responseAs(Void.class).pathParam("post_id", postId).queryParam("content", (Object)content).build();
    }

    public CallSpec<Void, HttpError> deleteCommentOfPost(String commentId) {
        return Resource.newDeleteSpec(this.api, "/v1/groups/forums/posts/comments/{comment_id}", false).responseAs(Void.class).pathParam("comment_id", commentId).build();
    }

    public CallSpec<List<XingUser>, HttpError> getLikersOfComment(String commentId) {
        return Resource.newGetSpec(this.api, "/v1/groups/forums/posts/comments/{comment_id}/likes").responseAs(GroupsResource.list(XingUser.class, new String[]{"likes", "users"})).pathParam("comment_id", commentId).build();
    }

    public CallSpec<Void, HttpError> likeComment(String commentId) {
        return Resource.newPutSpec(this.api, "/v1/groups/forums/posts/comments/{comment_id}/like", false).responseAs(Void.class).pathParam("comment_id", commentId).build();
    }

    public CallSpec<Void, HttpError> unlikeComment(String commentId) {
        return Resource.newDeleteSpec(this.api, "/v1/groups/forums/posts/comments/{comment_id}/like", false).responseAs(Void.class).pathParam("comment_id", commentId).build();
    }

    public CallSpec<Void, HttpError> markAllPostsAsRead(String groupId) {
        return Resource.newPutSpec(this.api, "/v1/groups/{group_id}/read", false).responseAs(Void.class).pathParam("group_id", groupId).build();
    }

    public CallSpec<Membership, HttpError> joinGroup(String groupId) {
        return Resource.newPostSpec(this.api, "/v1/groups/{group_id}/memberships", false).responseAs(GroupsResource.single(Membership.class, new String[]{"membership", "member_state"})).pathParam("group_id", groupId).build();
    }

    public CallSpec<Post, HttpError> createPost(String title, String content, String forumId) {
        return Resource.newPostSpec(this.api, "/v1/groups/forums/{forum_id}/posts", false).responseAs(GroupsResource.single(Post.class, new String[]{"post"})).pathParam("forum_id", forumId).queryParam("title", (Object)title).queryParam("content", (Object)content).build();
    }

    public CallSpec<Void, HttpError> deletePost(String postId) {
        return Resource.newDeleteSpec(this.api, "/v1/groups/forums/posts/{post_id}", false).responseAs(Void.class).pathParam("post_id", postId).build();
    }

    public CallSpec<Void, HttpError> leaveGroup(String groupId) {
        return Resource.newDeleteSpec(this.api, "/v1/groups/{group_id}/memberships", false).responseAs(Void.class).pathParam("group_id", groupId).build();
    }

    public CallSpec<MediaPreview, HttpError> createMediaPreview(String url) {
        return Resource.newPostSpec(this.api, "/v1/groups/media_previews", false).responseAs(GroupsResource.single(MediaPreview.class, new String[]{"media_preview"})).queryParam("url", (Object)url).build();
    }
}

