/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.resources;

import com.xing.api.CallSpec;
import com.xing.api.HttpError;
import com.xing.api.Resource;
import com.xing.api.XingApi;
import com.xing.api.data.jobs.Job;
import com.xing.api.data.jobs.PartialJob;
import java.util.List;

public class JobsResource
extends Resource {
    public static final Resource.Factory FACTORY = new Resource.Factory(JobsResource.class){

        @Override
        public Resource create(XingApi api) {
            return new JobsResource(api);
        }
    };

    JobsResource(XingApi api) {
        super(api);
    }

    public CallSpec<Job, HttpError> getJobById(String jobId) {
        return Resource.newGetSpec(this.api, "/v1/jobs/{id}").pathParam("id", jobId).responseAs(JobsResource.single(Job.class, new String[]{"job"})).build();
    }

    public CallSpec<List<PartialJob>, HttpError> getJobsByCriteria(String criteria) {
        return Resource.newGetSpec(this.api, "/v1/jobs/find").queryParam("query", (Object)criteria).responseAs(JobsResource.list(PartialJob.class, new String[]{"jobs", "items"})).build();
    }

    public CallSpec<List<PartialJob>, HttpError> getJobsRecommendationsForUser(String userId) {
        return Resource.newGetSpec(this.api, "/v1/users/{user_id}/jobs/recommendations").pathParam("user_id", userId).responseAs(JobsResource.list(PartialJob.class, new String[]{"job_recommendations", "items"})).build();
    }
}

