/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.resources;

import com.xing.api.CallSpec;
import com.xing.api.HttpError;
import com.xing.api.Resource;
import com.xing.api.XingApi;
import com.xing.api.data.messages.Conversation;
import com.xing.api.data.messages.ConversationMessage;
import com.xing.api.data.messages.MessageAttachment;
import java.util.List;

public class MessagesResource
extends Resource {
    public static final Resource.Factory FACTORY = new Resource.Factory(MessagesResource.class){

        @Override
        public Resource create(XingApi api) {
            return new MessagesResource(api);
        }
    };

    MessagesResource(XingApi api) {
        super(api);
    }

    public CallSpec<List<Conversation>, HttpError> getConversationsByUserId(String userId) {
        return Resource.newGetSpec(this.api, "/v1/users/{id}/conversations").pathParam("id", userId).responseAs(MessagesResource.list(Conversation.class, new String[]{"conversations", "items"})).build();
    }

    public CallSpec<Conversation, HttpError> createConversation(String userId, String subject, String content, String ... recipientIds) {
        return Resource.newPostSpec(this.api, "/v1/users/{user_id}/conversations", false).pathParam("user_id", userId).queryParam("content", (Object)content).queryParam("recipient_ids", recipientIds).queryParam("subject", (Object)subject).responseAs(MessagesResource.single(Conversation.class, new String[]{"conversation"})).build();
    }

    public CallSpec<Void, HttpError> validateRecipient(String userId) {
        return Resource.newGetSpec(this.api, "/v1/users/me/conversations/valid_recipients/{id}").pathParam("id", userId).responseAs(Void.class).build();
    }

    public CallSpec<Conversation, HttpError> getSingleConversation(String conversationId, String userId) {
        return Resource.newGetSpec(this.api, "/v1/users/{user_id}/conversations/{conversation_id}").pathParam("user_id", userId).pathParam("conversation_id", conversationId).responseAs(MessagesResource.single(Conversation.class, new String[]{"conversation"})).build();
    }

    public CallSpec<List<MessageAttachment>, HttpError> getAttachmentsOfConversation(String conversationId) {
        return Resource.newGetSpec(this.api, "/v1/users/me/conversations/{conversation_id}/attachments").pathParam("conversation_id", conversationId).responseAs(MessagesResource.list(MessageAttachment.class, new String[]{"attachments", "items"})).build();
    }

    public CallSpec<String, HttpError> getAttachmentDownloadLink(String conversationId, String attachmentId) {
        return Resource.newPostSpec(this.api, "/v1/users/me/conversations/{conversation_id}/attachments/{attachment_id}/download", false).pathParam("conversation_id", conversationId).pathParam("attachment_id", attachmentId).responseAs(MessagesResource.single(String.class, new String[]{"download", "url"})).build();
    }

    public CallSpec<Void, HttpError> markConversationAsRead(String conversationId, String userId) {
        return Resource.newPutSpec(this.api, "/v1/users/{user_id}/conversations/{conversation_id}/read", false).pathParam("user_id", userId).pathParam("conversation_id", conversationId).responseAs(Void.class).build();
    }

    public CallSpec<Void, HttpError> markConverastionAsUnread(String conversationId, String userId) {
        return Resource.newDeleteSpec(this.api, "/v1/users/{user_id}/conversations/{conversation_id}/read", false).pathParam("user_id", userId).pathParam("conversation_id", conversationId).responseAs(Void.class).build();
    }

    public CallSpec<List<ConversationMessage>, HttpError> getConversationMessages(String conversationId, String userId) {
        return Resource.newGetSpec(this.api, "/v1/users/{user_id}/conversations/{conversation_id}/messages").pathParam("user_id", userId).pathParam("conversation_id", conversationId).responseAs(MessagesResource.list(ConversationMessage.class, new String[]{"messages", "items"})).build();
    }

    public CallSpec<ConversationMessage, HttpError> getSingleConversationMessage(String conversationId, String messageId, String userId) {
        return Resource.newGetSpec(this.api, "/v1/users/{user_id}/conversations/{conversation_id}/messages/{message_id}").pathParam("user_id", userId).pathParam("conversation_id", conversationId).pathParam("message_id", messageId).responseAs(MessagesResource.single(ConversationMessage.class, new String[]{"message"})).build();
    }

    public CallSpec<Void, HttpError> markMessageAsRead(String conversationId, String messageId, String userId) {
        return Resource.newPutSpec(this.api, "/v1/users/{user_id}/conversations/{conversation_id}/messages/{message_id}/read", false).pathParam("user_id", userId).pathParam("conversation_id", conversationId).pathParam("message_id", messageId).responseAs(Void.class).build();
    }

    public CallSpec<Void, HttpError> markMessageAsUnread(String conversationId, String messageId, String userId) {
        return Resource.newDeleteSpec(this.api, "/v1/users/{user_id}/conversations/{conversation_id}/messages/{message_id}/read", false).pathParam("user_id", userId).pathParam("conversation_id", conversationId).pathParam("message_id", messageId).responseAs(Void.class).build();
    }

    public CallSpec<ConversationMessage, HttpError> sendMessageToConversation(String userId, String conversationId, String messageContent) {
        return Resource.newPostSpec(this.api, "/v1/users/{user_id}/conversations/{conversation_id}/messages", false).pathParam("user_id", userId).pathParam("conversation_id", conversationId).queryParam("content", (Object)messageContent).responseAs(MessagesResource.single(ConversationMessage.class, new String[]{"message"})).build();
    }

    public CallSpec<Void, HttpError> deleteConversation(String userId, String conversationId) {
        return Resource.newDeleteSpec(this.api, "/v1/users/{user_id}/conversations/{conversation_id}", false).pathParam("user_id", userId).pathParam("conversation_id", conversationId).responseAs(Void.class).build();
    }
}

