/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.resources;

import com.xing.api.CallSpec;
import com.xing.api.HttpError;
import com.xing.api.Resource;
import com.xing.api.XingApi;
import com.xing.api.data.edit.PictureUpload;
import com.xing.api.data.edit.UploadProgress;
import com.xing.api.data.profile.Address;
import com.xing.api.data.profile.Award;
import com.xing.api.data.profile.Company;
import com.xing.api.data.profile.FormOfEmployment;
import com.xing.api.data.profile.Language;
import com.xing.api.data.profile.LanguageSkill;
import com.xing.api.data.profile.LegalInformationComplete;
import com.xing.api.data.profile.MessagingAccount;
import com.xing.api.data.profile.School;
import com.xing.api.data.profile.WebProfile;
import com.xing.api.data.profile.XingUser;
import com.xing.api.internal.Experimental;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.List;
import okhttp3.RequestBody;

public class ProfileEditingResource
extends Resource {
    public static final Resource.Factory FACTORY = new Resource.Factory(ProfileEditingResource.class){

        @Override
        public Resource create(XingApi api) {
            return new ProfileEditingResource(api);
        }
    };

    ProfileEditingResource(XingApi api) {
        super(api);
    }

    public CallSpec<XingUser, HttpError> updateGeneralInformation() {
        return Resource.newPutSpec(this.api, "v1/users/me", false).responseAs(ProfileEditingResource.first(XingUser.class, new String[]{"users"})).build();
    }

    public CallSpec<Void, HttpError> updateProfilePicture(PictureUpload pictureUpload) {
        return Resource.newPutSpec(this.api, "v1/users/me/photo", false).responseAs(Void.class).body(ProfileEditingResource.single(PictureUpload.class, new String[]{"photo"}), pictureUpload).build();
    }

    public CallSpec<Void, HttpError> updateProfilePicture(RequestBody body) {
        return Resource.newPutSpec(this.api, "v1/users/me/photo", false).responseAs(Void.class).body(body).build();
    }

    public CallSpec<Void, HttpError> deleteProfilePicture() {
        return Resource.newDeleteSpec(this.api, "v1/users/me/photo", false).responseAs(Void.class).build();
    }

    @Experimental
    public CallSpec<UploadProgress, HttpError> getPictureUploadProgress() {
        return Resource.newGetSpec(this.api, "/v1/users/me/photo/progress").responseAs(ProfileEditingResource.single(UploadProgress.class, new String[]{"progress"})).build();
    }

    public CallSpec<Void, HttpError> updatePrivateAddress() {
        return Resource.newPutSpec(this.api, "/v1/users/me/private_address", true).responseAs(Void.class).build();
    }

    public CallSpec<Void, HttpError> updatePrivateAddress(Address address) {
        return Resource.newPutSpec(this.api, "/v1/users/me/private_address", false).responseAs(Void.class).body((Type)((Object)Address.class), address).build();
    }

    public CallSpec<Void, HttpError> updateBusinessAddress() {
        return Resource.newPutSpec(this.api, "/v1/users/me/business_address", true).responseAs(Void.class).build();
    }

    public CallSpec<Void, HttpError> updateBusinessAddress(Address address) {
        return Resource.newPutSpec(this.api, "/v1/users/me/business_address", false).responseAs(Void.class).body((Type)((Object)Address.class), address).build();
    }

    public CallSpec<School, HttpError> addSchool(String name) {
        return Resource.newPostSpec(this.api, "/v1/users/me/educational_background/schools", true).responseAs(ProfileEditingResource.single(School.class, new String[]{"school"})).formField("name", name).build();
    }

    public CallSpec<School, HttpError> addSchool(School school) {
        return Resource.newPostSpec(this.api, "/v1/users/me/educational_background/schools", false).responseAs(ProfileEditingResource.single(School.class, new String[]{"school"})).body((Type)((Object)School.class), school).build();
    }

    public CallSpec<School, HttpError> updateSchool(String schoolId) {
        return Resource.newPutSpec(this.api, "/v1/users/me/educational_background/schools/{id}", true).responseAs(ProfileEditingResource.single(School.class, new String[]{"school"})).pathParam("id", schoolId).build();
    }

    public CallSpec<Void, HttpError> deleteSchool(String schoolId) {
        return Resource.newDeleteSpec(this.api, "/v1/users/me/educational_background/schools/{id}", false).responseAs(Void.class).pathParam("id", schoolId).build();
    }

    public CallSpec<Void, HttpError> setSchoolAsPrimary(String schoolId) {
        return Resource.newPutSpec(this.api, "/v1/users/me/educational_background/primary_school", false).responseAs(Void.class).queryParam("school_id", (Object)schoolId).build();
    }

    public CallSpec<List<String>, HttpError> addQualification(String description) {
        return Resource.newPostSpec(this.api, "/v1/users/me/educational_background/qualifications", false).responseAs(ProfileEditingResource.list(String.class, new String[]{"qualifications"})).queryParam("description", (Object)description).build();
    }

    public CallSpec<Company, HttpError> addCompany(String name, String title, FormOfEmployment formOfEmployment) {
        return Resource.newPostSpec(this.api, "/v1/users/me/professional_experience/companies", true).responseAs(ProfileEditingResource.single(Company.class, new String[]{"company"})).formField("name", name).formField("title", title).formField("form_of_employment", (Object)formOfEmployment).build();
    }

    public CallSpec<Company, HttpError> updateCompany(String companyId) {
        return Resource.newPutSpec(this.api, "/v1/users/me/professional_experience/companies/{id}", true).responseAs(ProfileEditingResource.single(Company.class, new String[]{"company"})).pathParam("id", companyId).build();
    }

    public CallSpec<Void, HttpError> deleteCompany(String companyId) {
        return Resource.newDeleteSpec(this.api, "/v1/users/me/professional_experience/companies/{id}", false).responseAs(Void.class).pathParam("id", companyId).build();
    }

    public CallSpec<Void, HttpError> setCompanyAsPrimary(String companyId) {
        return Resource.newPutSpec(this.api, "/v1/users/me/professional_experience/primary_company", false).responseAs(Void.class).queryParam("company_id", (Object)companyId).build();
    }

    @Experimental
    public CallSpec<Void, HttpError> updateAwards(List<Award> awards) {
        return Resource.newPutSpec(this.api, "/v1/users/me/professional_experience/awards", false).responseAs(Void.class).body(ProfileEditingResource.list(Award.class, new String[]{"awards"}), awards).build();
    }

    public CallSpec<Void, HttpError> updateLanguageSkill(Language language, LanguageSkill skill) {
        return Resource.newPutSpec(this.api, "/v1/users/me/languages/{language}", false).responseAs(Void.class).pathParam("language", language.toString()).queryParam("skill", (Object)skill).build();
    }

    public CallSpec<Void, HttpError> deleteLanguage(Language language) {
        return Resource.newDeleteSpec(this.api, "/v1/users/me/languages/{language}", false).responseAs(Void.class).pathParam("language", language.toString()).build();
    }

    public CallSpec<Void, HttpError> updateBirthDate(Calendar calendar) {
        return Resource.newPutSpec(this.api, "/v1/users/me/birth_date", true).responseAs(Void.class).formField("day", calendar.get(5)).formField("month", calendar.get(2)).formField("year", calendar.get(1)).build();
    }

    @Experimental
    public CallSpec<Void, HttpError> updateWebProfile(WebProfile profile, List<String> urls) {
        return Resource.newPutSpec(this.api, "/v1/users/me/web_profiles/{profile}", false).responseAs(Void.class).pathParam("profile", profile.toString()).queryParam("url", urls).build();
    }

    public CallSpec<Void, HttpError> deleteWebProfile(WebProfile profile) {
        return Resource.newDeleteSpec(this.api, "/v1/users/me/web_profiles/{profile}", false).responseAs(Void.class).pathParam("profile", profile.toString()).build();
    }

    @Experimental
    public CallSpec<Void, HttpError> updateMessagingAccount(MessagingAccount account, String name) {
        return Resource.newPutSpec(this.api, "/v1/users/me/instant_messaging_accounts/{account}", false).responseAs(Void.class).pathParam("account", account.toString()).queryParam("name", (Object)name).build();
    }

    @Experimental
    public CallSpec<Void, HttpError> deleteMessagingAccount(MessagingAccount account) {
        return Resource.newDeleteSpec(this.api, "/v1/users/me/instant_messaging_accounts/{account}", false).responseAs(Void.class).pathParam("account", account.toString()).build();
    }

    @Experimental
    public CallSpec<Void, HttpError> updateLegalInfo(String legalInfo) {
        return Resource.newPutSpec(this.api, "/v1/users/me/legal_information", false).responseAs(Void.class).body((Type)((Object)LegalInformationComplete.class), new LegalInformationComplete(legalInfo)).build();
    }

    public CallSpec<Void, HttpError> updateUsersProfileMessage(String userId, String message) {
        return Resource.newPutSpec(this.api, "/v1/users/{user_id}/profile_message", true).responseAs(Void.class).pathParam("user_id", userId).queryParam("message", (Object)message).build();
    }
}

