/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.resources;

import com.xing.api.CallSpec;
import com.xing.api.HttpError;
import com.xing.api.Resource;
import com.xing.api.XingApi;
import com.xing.api.data.profile.XingUser;
import java.util.List;

public class RecommendationsResource
extends Resource {
    public static final Resource.Factory FACTORY = new Resource.Factory(RecommendationsResource.class){

        @Override
        public Resource create(XingApi api) {
            return new RecommendationsResource(api);
        }
    };

    RecommendationsResource(XingApi api) {
        super(api);
    }

    public CallSpec<List<XingUser>, HttpError> getOwnRecommendations() {
        return Resource.newGetSpec(this.api, "/v1/users/me/network/recommendations").responseAs(RecommendationsResource.list(RecommendationsResource.single(XingUser.class, new String[]{"user"}), "user_recommendations", "recommendations")).build();
    }

    public CallSpec<List<XingUser>, HttpError> getRecommendations(String userId) {
        return Resource.newGetSpec(this.api, "/v1/users/{user_id}/network/recommendations").pathParam("user_id", userId).responseAs(RecommendationsResource.list(RecommendationsResource.single(XingUser.class, new String[]{"user"}), "user_recommendations", "recommendations")).build();
    }

    public CallSpec<Void, HttpError> blockRecommendation(String userId) {
        return Resource.newDeleteSpec(this.api, "/v1/users/me/network/recommendations/user/{id}", false).pathParam("id", userId).responseAs(Void.class).build();
    }
}

