/*
 * Decompiled with CFR 0.152.
 */
package com.xing.api.resources;

import com.xing.api.CallSpec;
import com.xing.api.HttpError;
import com.xing.api.Resource;
import com.xing.api.XingApi;
import com.xing.api.data.profile.ProfileMessage;
import com.xing.api.data.profile.XingUser;
import com.xing.api.internal.Experimental;
import java.util.List;

public class UserProfilesResource
extends Resource {
    public static final Resource.Factory FACTORY = new Resource.Factory(UserProfilesResource.class){

        @Override
        public Resource create(XingApi api) {
            return new UserProfilesResource(api);
        }
    };

    UserProfilesResource(XingApi api) {
        super(api);
    }

    public CallSpec<List<XingUser>, HttpError> getUsersById(List<String> ids) {
        return Resource.newGetSpec(this.api, "/v1/users/{ids}").pathParam("ids", ids).responseAs(UserProfilesResource.list(XingUser.class, new String[]{"users"})).build();
    }

    public CallSpec<XingUser, HttpError> getUserById(String id) {
        return Resource.newGetSpec(this.api, "/v1/users/{id}").pathParam("id", id).responseAs(UserProfilesResource.first(XingUser.class, new String[]{"users"})).build();
    }

    public CallSpec<XingUser, HttpError> getOwnProfile() {
        return this.getUserById("me");
    }

    public CallSpec<XingUser, HttpError> getOwnIdCard() {
        return Resource.newGetSpec(this.api, "/v1/users/me/id_card").responseAs(UserProfilesResource.single(XingUser.class, new String[]{"id_card"})).build();
    }

    public CallSpec<List<XingUser>, HttpError> findUsersByEmail(List<String> emails) {
        return Resource.newGetSpec(this.api, "/v1/users/find_by_emails").responseAs(UserProfilesResource.list(UserProfilesResource.single(XingUser.class, new String[]{"user"}), "results", "items")).queryParam("emails", emails).build();
    }

    @Experimental
    public CallSpec<List<XingUser>, HttpError> findUsersByKeyword(String keywords) {
        return Resource.newGetSpec(this.api, "/v1/users/find").responseAs(UserProfilesResource.list(UserProfilesResource.single(XingUser.class, new String[]{"user"}), "users", "items")).queryParam("keywords", (Object)keywords).build();
    }

    public CallSpec<ProfileMessage, HttpError> getUserProfileMessage(String userId) {
        return Resource.newGetSpec(this.api, "/v1/{user_id}/profile_message").pathParam("user_id", userId).responseAs(UserProfilesResource.single(ProfileMessage.class, new String[]{"profile_message"})).build();
    }

    public CallSpec<ProfileMessage, HttpError> getOwnProfileMessage() {
        return this.getUserProfileMessage("me");
    }

    public CallSpec<String, HttpError> getUserLegalInformation(String userId) {
        return Resource.newGetSpec(this.api, "/v1/users/{user_id}/legal_information").pathParam("user_id", userId).responseAs(UserProfilesResource.single(String.class, new String[]{"legal_information", "content"})).build();
    }

    public CallSpec<String, HttpError> getOwnLegalInformation() {
        return this.getUserLegalInformation("me");
    }
}

