/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.jsf.sample.carshop;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;

@ManagedBean
@SessionScoped
public class DynamicOptionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> brand2Type = new HashMap();
    private List<String> types = new ArrayList();
    private String brand = null;
    private String type = null;

    public DynamicOptionBean() {
        this.initBrandsAndTypes();
        this.types.add("");
        this.types.add("Civic");
        this.types.add("Golf");
        this.types.add("320");
        this.types.add("V50");
        this.types.add("Astra");
        this.types.add("Megane");
        this.types.add("Picasso");
        this.types.add("Ibiza");
        this.types.add("Punto");
    }

    public String getBrandToType(String type) {
        if (type == null) {
            return "";
        }
        return (String)this.brand2Type.get(type);
    }

    public List<String> getTypes() {
        return this.getTypesToBrand(this.brand);
    }

    public List<String> getTypesToBrand(String brand) {
        if (brand == null || brand.length() == 0) {
            return this.types;
        }
        ArrayList<String> l = new ArrayList<String>();
        Set entrySet = this.brand2Type.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!((String)entry.getValue()).equals(brand)) continue;
            l.add((String)entry.getKey());
        }
        if (l.size() > 0) {
            l.add(0, "");
        }
        return l;
    }

    public void initBrandsAndTypes() {
        this.brand2Type.put("Civic", "Honda");
        this.brand2Type.put("Jazz", "Honda");
        this.brand2Type.put("Golf", "VW");
        this.brand2Type.put("Passat", "VW");
        this.brand2Type.put("Polo", "VW");
        this.brand2Type.put("320", "BMW");
        this.brand2Type.put("C40", "Volvo");
        this.brand2Type.put("V50", "Volvo");
        this.brand2Type.put("C60", "Volvo");
        this.brand2Type.put("V70", "Volvo");
        this.brand2Type.put("Corsa", "Opel");
        this.brand2Type.put("Astra", "Opel");
        this.brand2Type.put("Vectra", "Opel");
        this.brand2Type.put("Picasso", "Citroen");
        this.brand2Type.put("Le\u00f3n", "Seat");
        this.brand2Type.put("Ibiza", "Seat");
        this.brand2Type.put("Exeo", "Seat");
        this.brand2Type.put("Punto", "Fiat");
        this.brand2Type.put("500", "Fiat");
        this.brand2Type.put("Panda", "Fiat");
        this.brand2Type.put("Megane", "Renault");
    }

    public void setBrandAndType(String brand, String type) {
        this.brand = brand;
        this.type = type;
    }
}

