/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.jsf.sample.carshop;

import de.beyondjava.jsf.sample.carshop.Car;
import de.beyondjava.jsf.sample.carshop.CustomerBean;
import java.io.Serializable;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ManagedBean
@SessionScoped
public class NewCarBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Car car = new Car(null, null, 0, null, 0, null, 0);
    @ManagedProperty(value="#{customerBean}")
    private CustomerBean customerBean;

    public CustomerBean getCustomerBean() {
        return this.customerBean;
    }

    public void setCustomerBean(CustomerBean customerBean) {
        this.customerBean = customerBean;
    }

    @NotNull
    @Size(min=2, max=10)
    public String getBrand() {
        return this.car.getBrand();
    }

    @NotNull
    @Size(min=2, max=10)
    public String getColor() {
        return this.car.getColor();
    }

    @NotNull
    @Size(min=2, max=10)
    public String getFuel() {
        return this.car.getFuel();
    }

    @Min(value=0L)
    @Max(value=1000000L)
    public int getMileage() {
        return this.car.getMileage();
    }

    @Min(value=1L)
    @Max(value=5000000L)
    public int getPrice() {
        return this.car.getPrice();
    }

    @NotNull
    @Size(min=1, max=10)
    public String getType() {
        return this.car.getType();
    }

    @NotNull
    @Min(value=1886L)
    @Max(value=2014L)
    public int getYear() {
        return this.car.getYear();
    }

    public void setBrand(String brand) {
        this.car.setBrand(brand);
    }

    public void setColor(String color) {
        this.car.setColor(color);
    }

    public void setFuel(String fuel) {
        this.car.setFuel(fuel);
    }

    public void setMileage(int mileage) {
        this.car.setMileage(mileage);
    }

    public void setPrice(int price) {
        this.car.setPrice(price);
    }

    public void setType(String type) {
        this.car.setType(type);
    }

    public void setYear(int year) {
        this.car.setYear(year);
    }

    public String sell() {
        if (this.customerBean.getCaptcha() != this.customerBean.getExpectedCaptcha()) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "CAPTCHA", "Please solve the equation!"));
            return "index.jsf?tab=2";
        }
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "CAPTCHA", "Thanks for selling this car!"));
        return "sold.jsf";
    }
}

