/*
 * Decompiled with CFR 0.152.
 */
package dev.bpmcrafters.processengineapi.impl.task;

import dev.bpmcrafters.processengineapi.Empty;
import dev.bpmcrafters.processengineapi.impl.task.AbstractTaskSubscriptionApiImplKt;
import dev.bpmcrafters.processengineapi.impl.task.SubscriptionRepository;
import dev.bpmcrafters.processengineapi.impl.task.TaskSubscriptionHandle;
import dev.bpmcrafters.processengineapi.task.SubscribeForTaskCmd;
import dev.bpmcrafters.processengineapi.task.TaskHandler;
import dev.bpmcrafters.processengineapi.task.TaskSubscription;
import dev.bpmcrafters.processengineapi.task.TaskSubscriptionApi;
import dev.bpmcrafters.processengineapi.task.TaskTerminationHandler;
import dev.bpmcrafters.processengineapi.task.TaskType;
import dev.bpmcrafters.processengineapi.task.UnsubscribeFromTaskCmd;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\t\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/bpmcrafters/processengineapi/impl/task/AbstractTaskSubscriptionApiImpl;", "Ldev/bpmcrafters/processengineapi/task/TaskSubscriptionApi;", "subscriptionRepository", "Ldev/bpmcrafters/processengineapi/impl/task/SubscriptionRepository;", "<init>", "(Ldev/bpmcrafters/processengineapi/impl/task/SubscriptionRepository;)V", "subscribeForTask", "Ljava/util/concurrent/CompletableFuture;", "Ldev/bpmcrafters/processengineapi/task/TaskSubscription;", "cmd", "Ldev/bpmcrafters/processengineapi/task/SubscribeForTaskCmd;", "unsubscribe", "Ldev/bpmcrafters/processengineapi/Empty;", "Ldev/bpmcrafters/processengineapi/task/UnsubscribeFromTaskCmd;", "getSupportedRestrictions", "", "", "ensure", "Ldev/bpmcrafters/processengineapi/impl/task/TaskSubscriptionHandle;", "subscription", "process-engine-api-impl"})
public abstract class AbstractTaskSubscriptionApiImpl
implements TaskSubscriptionApi {
    @NotNull
    private final SubscriptionRepository subscriptionRepository;

    public AbstractTaskSubscriptionApiImpl(@NotNull SubscriptionRepository subscriptionRepository) {
        Intrinsics.checkNotNullParameter((Object)subscriptionRepository, (String)"subscriptionRepository");
        this.subscriptionRepository = subscriptionRepository;
    }

    @NotNull
    public CompletableFuture<TaskSubscription> subscribeForTask(@NotNull SubscribeForTaskCmd cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        String string = cmd.getTaskDescriptionKey();
        Set set = cmd.getPayloadDescription();
        Map map = cmd.getRestrictions();
        TaskHandler taskHandler = cmd.getAction();
        TaskType taskType = cmd.getTaskType();
        TaskTerminationHandler taskTerminationHandler = cmd.getTermination();
        TaskSubscriptionHandle it = new TaskSubscriptionHandle(taskType, set, map, string, taskHandler, taskTerminationHandler);
        boolean bl = false;
        this.subscriptionRepository.createTaskSubscription(it);
        AbstractTaskSubscriptionApiImplKt.access$getLogger$p().info(() -> AbstractTaskSubscriptionApiImpl.subscribeForTask$lambda$1$lambda$0(it));
        CompletableFuture<TaskSubscription> completableFuture = CompletableFuture.completedFuture(it);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"let(...)");
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Empty> unsubscribe(@NotNull UnsubscribeFromTaskCmd cmd) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        this.subscriptionRepository.deleteTaskSubscription(this.ensure(cmd.getSubscription()));
        AbstractTaskSubscriptionApiImplKt.access$getLogger$p().info(() -> AbstractTaskSubscriptionApiImpl.unsubscribe$lambda$2(cmd));
        CompletableFuture<Empty> completableFuture = CompletableFuture.completedFuture(Empty.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @NotNull
    public Set<String> getSupportedRestrictions() {
        return SetsKt.emptySet();
    }

    private final TaskSubscriptionHandle ensure(TaskSubscription subscription) {
        if (!(subscription instanceof TaskSubscriptionHandle)) {
            boolean bl = false;
            String string = "Only subscriptions of type " + TaskSubscriptionHandle.class.getName() + " are supported, but got " + subscription.getClass().getName() + ".";
            throw new IllegalArgumentException(string.toString());
        }
        return (TaskSubscriptionHandle)subscription;
    }

    public boolean areSupported(@NotNull Map<String, String> restrictions) {
        return super.areSupported(restrictions);
    }

    @NotNull
    public Map<String, String> ensureSupported(@NotNull Map<String, String> restrictions) {
        return super.ensureSupported(restrictions);
    }

    private static final Object subscribeForTask$lambda$1$lambda$0(TaskSubscriptionHandle $it) {
        return "PROCESS-ENGINE-API-001: Registered new task subscription " + $it;
    }

    private static final Object unsubscribe$lambda$2(UnsubscribeFromTaskCmd $cmd) {
        return "PROCESS-ENGINE-API-002: Un-registered new task subscription " + $cmd.getSubscription();
    }
}

