

package gov.nist.secauto.metaschema.cli.processor;

import static org.fusesource.jansi.Ansi.ansi;

import java.io.PrintStream;

public class Version implements VersionInfo {

  public static final String VERSION = "1.0.1";
  public static final String BUILD_TIMESTAMP = "2024-08-04 05:00";
  public static final String COMMIT = "87dd858";

  public Version() {
  }

  @Override
  public String getVersion() {
    return VERSION;
  }

  @Override
  public String getBuildTime() {
    return BUILD_TIMESTAMP;
  }

  @Override
  public String getCommit() {
    return COMMIT;
  }
  
  @Override
  public void generateExtraInfo(PrintStream out) {
    out.println(ansi()
        .a("Metaschema version ").bold().a(getVersion()).boldOff()
        .a(" on commit ").bold().a(getCommit()).boldOff()
        .a(" built at ").bold().a( getBuildTime()).reset());
  }
}
