

package gov.nist.secauto.metaschema.cli.processor;

import gov.nist.secauto.metaschema.core.util.IVersionInfo;

/**
 * Provides version information for this library.
 * <p>
 * This class exposes build-time metadata including version numbers, build
 * timestamps, and Git repository information.
 */
public class ProcessorVersion implements IVersionInfo {

  private static final String NAME = "Metaschema CLI Framework";
  private static final String VERSION = "3.0.0.M1";
  private static final String BUILD_TIMESTAMP = "2025-12-14 18:01";
  private static final String COMMIT = "1a75306";
  private static final String BRANCH = "1a75306c4f33c4799cd7bc1fdf3ed7781f9f7380";
  private static final String CLOSEST_TAG = "";
  private static final String ORIGIN = "https://github.com/metaschema-framework/metaschema-java";

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public String getVersion() {
    return VERSION;
  }

  @Override
  public String getBuildTimestamp() {
    return BUILD_TIMESTAMP;
  }

  @Override
  public String getGitOriginUrl() {
    return ORIGIN;
  }

  @Override
  public String getGitCommit() {
    return COMMIT;
  }

  @Override
  public String getGitBranch() {
    return BRANCH;
  }

  @Override
  public String getGitClosestTag() {
    return CLOSEST_TAG;
  }
}
