/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.processor.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.processor.command.ICommand;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import nl.talsmasoftware.lazy4j.Lazy;

public final class CommandService {
    private static final Lazy<CommandService> INSTANCE = Lazy.of(CommandService::new);
    @NonNull
    private final ServiceLoader<ICommand> loader;

    public static CommandService getInstance() {
        return (CommandService)INSTANCE.get();
    }

    private CommandService() {
        ServiceLoader<ICommand> loader = ServiceLoader.load(ICommand.class);
        assert (loader != null);
        this.loader = loader;
    }

    @NonNull
    private ServiceLoader<ICommand> getLoader() {
        return this.loader;
    }

    @NonNull
    public List<ICommand> getCommands() {
        return (List)ObjectUtils.notNull(this.getLoader().stream().map(ServiceLoader.Provider::get).collect(Collectors.toUnmodifiableList()));
    }
}

