

package dev.metaschema.cli.processor;

import dev.metaschema.core.util.IVersionInfo;

/**
 * Provides version information for this library.
 * <p>
 * This class exposes build-time metadata including version numbers, build
 * timestamps, and Git repository information.
 */
public class ProcessorVersion implements IVersionInfo {

  private static final String NAME = "Metaschema CLI Framework";
  private static final String VERSION = "3.0.0.M2";
  private static final String BUILD_TIMESTAMP = "2026-01-12 01:53";
  private static final String COMMIT = "dd35fa4";
  private static final String BRANCH = "dd35fa4e84a70974f9ef9f6b6767015b2c06225f";
  private static final String CLOSEST_TAG = "";
  private static final String ORIGIN = "https://github.com/metaschema-framework/metaschema-java";

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public String getVersion() {
    return VERSION;
  }

  @Override
  public String getBuildTimestamp() {
    return BUILD_TIMESTAMP;
  }

  @Override
  public String getGitOriginUrl() {
    return ORIGIN;
  }

  @Override
  public String getGitCommit() {
    return COMMIT;
  }

  @Override
  public String getGitBranch() {
    return BRANCH;
  }

  @Override
  public String getGitClosestTag() {
    return CLOSEST_TAG;
  }
}
