/*
 * Decompiled with CFR 0.152.
 */
package dev.metaschema.cli.processor;

import dev.metaschema.cli.processor.ExitCode;
import dev.metaschema.cli.processor.ExitStatus;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractExitStatus
implements ExitStatus {
    private static final Logger LOGGER = LogManager.getLogger(AbstractExitStatus.class);
    @NonNull
    private final ExitCode exitCode;
    private Throwable throwable;

    public AbstractExitStatus(@NonNull ExitCode exitCode) {
        this.exitCode = exitCode;
    }

    @Override
    public ExitCode getExitCode() {
        return this.exitCode;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="intended as a exposed property")
    public ExitStatus withThrowable(@NonNull Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    @Nullable
    private LogBuilder getLogBuilder() {
        LogBuilder logBuilder = null;
        if (this.getExitCode().getStatusCode() <= 0) {
            if (LOGGER.isInfoEnabled()) {
                logBuilder = LOGGER.atInfo();
            }
        } else if (LOGGER.isErrorEnabled()) {
            logBuilder = LOGGER.atError();
        }
        return logBuilder;
    }

    @Override
    public void generateMessage(boolean showStackTrace) {
        boolean useStackTrace;
        LogBuilder logBuilder = this.getLogBuilder();
        if (logBuilder == null) {
            return;
        }
        boolean bl = useStackTrace = showStackTrace && this.throwable != null;
        if (useStackTrace) {
            logBuilder.withThrowable(this.throwable);
        }
        String message = this.getMessage();
        if (this.throwable != null && message == null) {
            message = this.throwable.getLocalizedMessage();
        }
        if (message != null && !message.isEmpty()) {
            logBuilder.log(message);
        } else if (useStackTrace) {
            logBuilder.log();
        }
    }
}

