/*
 * Decompiled with CFR 0.152.
 */
package dev.metaschema.cli.processor;

import dev.metaschema.cli.processor.CallingContext;
import dev.metaschema.cli.processor.ExitCode;
import dev.metaschema.cli.processor.ExitStatus;
import dev.metaschema.cli.processor.ProcessorVersion;
import dev.metaschema.cli.processor.command.CommandService;
import dev.metaschema.cli.processor.command.ICommand;
import dev.metaschema.core.util.CollectionUtil;
import dev.metaschema.core.util.IVersionInfo;
import dev.metaschema.core.util.ObjectUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.eclipse.jdt.annotation.NotOwning;
import org.jline.jansi.Ansi;

public class CLIProcessor {
    private static final Logger LOGGER = LogManager.getLogger(CLIProcessor.class);
    @NonNull
    public static final Option HELP_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder((String)"h").longOpt("help").desc("display this help message").get());
    @NonNull
    public static final Option NO_COLOR_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("no-color").desc("do not colorize output").get());
    @NonNull
    public static final Option QUIET_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder((String)"q").longOpt("quiet").desc("minimize output to include only errors").get());
    @NonNull
    public static final Option SHOW_STACK_TRACE_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("show-stack-trace").desc("display the stack trace associated with an error").get());
    @NonNull
    public static final Option VERSION_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("version").desc("display the application version").get());
    @NonNull
    static final List<Option> OPTIONS = (List)ObjectUtils.notNull(List.of(HELP_OPTION, NO_COLOR_OPTION, QUIET_OPTION, SHOW_STACK_TRACE_OPTION, VERSION_OPTION));
    public static final String COMMAND_VERSION = "http://csrc.nist.gov/ns/metaschema-java/cli/command-version";
    @NonNull
    private final List<ICommand> commands = new LinkedList<ICommand>();
    @NonNull
    private final String exec;
    @NonNull
    private final Map<String, IVersionInfo> versionInfos;
    @NonNull
    @NotOwning
    private final PrintStream outputStream;

    public static void main(String ... args) {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        CLIProcessor processor = new CLIProcessor("metaschema-cli");
        CommandService.getInstance().getCommands().stream().forEach(command -> {
            assert (command != null);
            processor.addCommandHandler((ICommand)command);
        });
        System.exit(processor.process(args).getExitCode().getStatusCode());
    }

    public CLIProcessor(@NonNull String args) {
        this(args, CollectionUtil.singletonMap((Object)COMMAND_VERSION, (Object)new ProcessorVersion()));
    }

    public CLIProcessor(@NonNull String exec, @NonNull Map<String, IVersionInfo> versionInfos) {
        this(exec, versionInfos, null);
    }

    public CLIProcessor(@NonNull String exec, @NonNull Map<String, IVersionInfo> versionInfos, @Nullable @NotOwning PrintStream outputStream) {
        this.exec = exec;
        this.versionInfos = versionInfos;
        this.outputStream = outputStream != null ? outputStream : (PrintStream)ObjectUtils.notNull((Object)System.out);
    }

    @NonNull
    public String getExec() {
        return this.exec;
    }

    @NonNull
    public Map<String, IVersionInfo> getVersionInfos() {
        return this.versionInfos;
    }

    public void addCommandHandler(@NonNull ICommand handler) {
        this.commands.add(handler);
    }

    @NonNull
    public ExitStatus process(String ... args) {
        return this.parseCommand(args);
    }

    @NonNull
    private ExitStatus parseCommand(String ... args) {
        ExitStatus status;
        List<String> commandArgs = Arrays.asList(args);
        assert (commandArgs != null);
        CallingContext callingContext = new CallingContext(this, commandArgs);
        if (LOGGER.isDebugEnabled()) {
            String commandChain = callingContext.getCalledCommands().stream().map(ICommand::getName).collect(Collectors.joining(" -> "));
            LOGGER.debug("Processing command chain: {}", (Object)commandChain);
        }
        if (commandArgs.isEmpty()) {
            status = ExitCode.INVALID_COMMAND.exit();
            callingContext.showHelp();
        } else {
            status = callingContext.processCommand();
        }
        return status;
    }

    @NonNull
    public final List<ICommand> getTopLevelCommands() {
        return CollectionUtil.unmodifiableList(this.commands);
    }

    @NonNull
    protected final Map<String, ICommand> getTopLevelCommandsByName() {
        return (Map)ObjectUtils.notNull(this.getTopLevelCommands().stream().collect(Collectors.toUnmodifiableMap(ICommand::getName, Function.identity())));
    }

    static void handleNoColor() {
        Ansi.setEnabled((boolean)false);
    }

    @NonNull
    @NotOwning
    PrintStream getOutputStream() {
        return this.outputStream;
    }

    static void handleQuiet() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        Level oldLevel = loggerConfig.getLevel();
        if (oldLevel.isLessSpecificThan(Level.ERROR)) {
            loggerConfig.setLevel(Level.ERROR);
            ctx.updateLoggers();
        }
    }

    protected void showVersion() {
        this.getVersionInfos().values().stream().forEach(info -> this.outputStream.println(Ansi.ansi().bold().a(info.getName()).boldOff().a(" ").bold().a(info.getVersion()).boldOff().a(" built at ").bold().a(info.getBuildTimestamp()).boldOff().a(" from branch ").bold().a(info.getGitBranch()).boldOff().a(" (").bold().a(info.getGitCommit()).boldOff().a(") at ").bold().a(info.getGitOriginUrl()).boldOff().reset()));
        this.outputStream.flush();
    }
}

