/*
 * Decompiled with CFR 0.152.
 */
package dev.metaschema.cli.processor;

import dev.metaschema.cli.processor.CLIProcessor;
import dev.metaschema.cli.processor.ExitCode;
import dev.metaschema.cli.processor.ExitStatus;
import dev.metaschema.cli.processor.InvalidArgumentException;
import dev.metaschema.cli.processor.OptionUtils;
import dev.metaschema.cli.processor.command.CommandExecutionException;
import dev.metaschema.cli.processor.command.ExtraArgument;
import dev.metaschema.cli.processor.command.ICommand;
import dev.metaschema.cli.processor.command.ICommandExecutor;
import dev.metaschema.core.util.AutoCloser;
import dev.metaschema.core.util.CollectionUtil;
import dev.metaschema.core.util.ObjectUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.help.HelpAppendable;
import org.apache.commons.cli.help.HelpFormatter;
import org.apache.commons.cli.help.OptionFormatter;
import org.apache.commons.cli.help.TextHelpAppendable;
import org.jline.jansi.Ansi;

public class CallingContext {
    @NonNull
    private final CLIProcessor cliProcessor;
    @NonNull
    private final List<Option> options;
    @NonNull
    private final List<ICommand> calledCommands;
    @Nullable
    private final ICommand targetCommand;
    @NonNull
    private final List<String> extraArgs;
    private static final int DEFAULT_TERMINAL_WIDTH = 80;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
    CallingContext(@NonNull CLIProcessor cliProcessor, @NonNull List<String> args) {
        this.cliProcessor = cliProcessor;
        LinkedList calledCommands = new LinkedList();
        LinkedList<Option> options = new LinkedList<Option>(CLIProcessor.OPTIONS);
        LinkedList extraArgs = new LinkedList();
        AtomicBoolean endArgs = new AtomicBoolean();
        args.forEach(arg -> {
            if (endArgs.get() || arg.startsWith("-")) {
                extraArgs.add(arg);
            } else if ("--".equals(arg)) {
                endArgs.set(true);
            } else {
                ICommand command;
                ICommand iCommand = command = calledCommands.isEmpty() ? cliProcessor.getTopLevelCommandsByName().get(arg) : ((ICommand)calledCommands.getLast()).getSubCommandByName((String)arg);
                if (command == null) {
                    extraArgs.add(arg);
                    endArgs.set(true);
                } else {
                    calledCommands.add(command);
                    options.addAll(command.gatherOptions());
                }
            }
        });
        this.calledCommands = CollectionUtil.unmodifiableList(calledCommands);
        this.targetCommand = (ICommand)calledCommands.peekLast();
        this.options = CollectionUtil.unmodifiableList(options);
        this.extraArgs = CollectionUtil.unmodifiableList(extraArgs);
    }

    @NonNull
    public CLIProcessor getCLIProcessor() {
        return this.cliProcessor;
    }

    @Nullable
    public ICommand getTargetCommand() {
        return this.targetCommand;
    }

    @NonNull
    List<Option> getOptionsList() {
        return this.options;
    }

    @NonNull
    List<ICommand> getCalledCommands() {
        return this.calledCommands;
    }

    @NonNull
    List<String> getExtraArgs() {
        return this.extraArgs;
    }

    Options toOptions() {
        Options retval = new Options();
        for (Option option : this.getOptionsList()) {
            retval.addOption(option);
        }
        return retval;
    }

    @NonNull
    protected Optional<ExitStatus> checkHelpAndVersion() {
        Options phase1Options = new Options();
        phase1Options.addOption(CLIProcessor.HELP_OPTION);
        phase1Options.addOption(CLIProcessor.VERSION_OPTION);
        try {
            CommandLine cmdLine = new DefaultParser().parse(phase1Options, this.getExtraArgs().toArray(new String[0]), true);
            if (cmdLine.hasOption(CLIProcessor.VERSION_OPTION)) {
                this.cliProcessor.showVersion();
                return (Optional)ObjectUtils.notNull(Optional.of(ExitCode.OK.exit()));
            }
            if (cmdLine.hasOption(CLIProcessor.HELP_OPTION)) {
                this.showHelp();
                return (Optional)ObjectUtils.notNull(Optional.of(ExitCode.OK.exit()));
            }
        }
        catch (ParseException ex) {
            String msg = ex.getMessage();
            return (Optional)ObjectUtils.notNull(Optional.of(this.handleInvalidCommand(msg != null ? msg : "Invalid command")));
        }
        return (Optional)ObjectUtils.notNull(Optional.empty());
    }

    @NonNull
    protected CommandLine parseOptions() throws ParseException {
        return (CommandLine)ObjectUtils.notNull((Object)new DefaultParser().parse(this.toOptions(), this.getExtraArgs().toArray(new String[0])));
    }

    @NonNull
    protected Optional<ExitStatus> validateExtraArguments(@NonNull CommandLine cmdLine) {
        ICommand target = this.getTargetCommand();
        if (target == null) {
            return (Optional)ObjectUtils.notNull(Optional.empty());
        }
        try {
            target.validateExtraArguments(this, cmdLine);
            return (Optional)ObjectUtils.notNull(Optional.empty());
        }
        catch (InvalidArgumentException ex) {
            return (Optional)ObjectUtils.notNull(Optional.of(this.handleError(ExitCode.INVALID_ARGUMENTS.exitMessage(ex.getLocalizedMessage()), cmdLine, true)));
        }
    }

    @NonNull
    protected Optional<ExitStatus> validateCalledCommands(@NonNull CommandLine cmdLine) {
        for (ICommand cmd : this.getCalledCommands()) {
            try {
                cmd.validateOptions(this, cmdLine);
            }
            catch (InvalidArgumentException ex) {
                String msg = ex.getMessage();
                return (Optional)ObjectUtils.notNull(Optional.of(this.handleInvalidCommand(msg != null ? msg : "Invalid argument")));
            }
        }
        return (Optional)ObjectUtils.notNull(Optional.empty());
    }

    protected void applyGlobalOptions(@NonNull CommandLine cmdLine) {
        if (cmdLine.hasOption(CLIProcessor.NO_COLOR_OPTION)) {
            CLIProcessor.handleNoColor();
        }
        if (cmdLine.hasOption(CLIProcessor.QUIET_OPTION)) {
            CLIProcessor.handleQuiet();
        }
    }

    @NonNull
    public ExitStatus processCommand() {
        CommandLine cmdLine;
        Optional<ExitStatus> earlyExit = this.checkHelpAndVersion();
        if (earlyExit.isPresent()) {
            return earlyExit.get();
        }
        try {
            cmdLine = this.parseOptions();
        }
        catch (ParseException ex) {
            String msg = ex.getMessage();
            return this.handleInvalidCommand(msg != null ? msg : "Parse error");
        }
        Optional<ExitStatus> validationResult = this.validateExtraArguments(cmdLine).or(() -> this.validateCalledCommands(cmdLine));
        if (validationResult.isPresent()) {
            return validationResult.get();
        }
        this.applyGlobalOptions(cmdLine);
        return this.invokeCommand(cmdLine);
    }

    @NonNull
    private ExitStatus invokeCommand(@NonNull CommandLine cmdLine) {
        ExitStatus retval;
        try {
            ICommand targetCommand = this.getTargetCommand();
            if (targetCommand == null) {
                retval = ExitCode.INVALID_COMMAND.exit();
            } else {
                ICommandExecutor executor = targetCommand.newExecutor(this, cmdLine);
                try {
                    executor.execute();
                    retval = ExitCode.OK.exit();
                }
                catch (CommandExecutionException ex) {
                    retval = ex.toExitStatus();
                }
                catch (RuntimeException ex) {
                    retval = ExitCode.RUNTIME_ERROR.exitMessage("Unexpected error occurred: " + ex.getLocalizedMessage()).withThrowable(ex);
                }
            }
        }
        catch (RuntimeException ex) {
            retval = ExitCode.RUNTIME_ERROR.exitMessage(String.format("An uncaught runtime error occurred. %s", ex.getLocalizedMessage())).withThrowable(ex);
        }
        if (!ExitCode.OK.equals((Object)retval.getExitCode())) {
            retval.generateMessage(cmdLine.hasOption(CLIProcessor.SHOW_STACK_TRACE_OPTION));
            if (ExitCode.INVALID_COMMAND.equals((Object)retval.getExitCode())) {
                this.showHelp();
            }
        }
        return retval;
    }

    @NonNull
    public ExitStatus handleError(@NonNull ExitStatus exitStatus, @NonNull CommandLine cmdLine, boolean showHelp) {
        exitStatus.generateMessage(cmdLine.hasOption(CLIProcessor.SHOW_STACK_TRACE_OPTION));
        if (showHelp) {
            this.showHelp();
        }
        return exitStatus;
    }

    @NonNull
    public ExitStatus handleInvalidCommand(@NonNull String message) {
        this.showHelp();
        ExitStatus retval = ExitCode.INVALID_COMMAND.exitMessage(message);
        retval.generateMessage(false);
        return retval;
    }

    @Nullable
    private static String buildHelpHeader() {
        return null;
    }

    @NonNull
    private String buildHelpFooter(int terminalWidth) {
        String retval;
        ICommand targetCommand = this.getTargetCommand();
        Collection<ICommand> subCommands = targetCommand == null ? this.cliProcessor.getTopLevelCommands() : targetCommand.getSubCommands();
        if (subCommands.isEmpty()) {
            retval = "";
        } else {
            StringBuilder builder = new StringBuilder(128);
            builder.append(System.lineSeparator()).append("The following are available commands:").append(System.lineSeparator());
            int commandColWidth = subCommands.stream().mapToInt(command -> command.getName().length()).max().orElse(0);
            int prefixWidth = 3 + commandColWidth + 1;
            int descWidth = Math.max(terminalWidth - prefixWidth, 20);
            String continuationIndent = " ".repeat(prefixWidth);
            for (ICommand command2 : subCommands) {
                String wrappedDesc = CallingContext.wrapText(command2.getDescription(), descWidth, continuationIndent);
                builder.append(Ansi.ansi().render(String.format("   @|bold %-" + commandColWidth + "s|@ %s%n", command2.getName(), wrappedDesc)));
            }
            builder.append(System.lineSeparator()).append('\'').append(this.cliProcessor.getExec()).append(" <command> --help' will show help on that specific command.").append(System.lineSeparator());
            retval = builder.toString();
            assert (retval != null);
        }
        return retval;
    }

    private String buildHelpCliSyntax() {
        ICommand targetCommand;
        StringBuilder builder = new StringBuilder(64);
        builder.append(this.cliProcessor.getExec());
        List<ICommand> calledCommands = this.getCalledCommands();
        if (!calledCommands.isEmpty()) {
            builder.append(calledCommands.stream().map(ICommand::getName).collect(Collectors.joining(" ", " ", "")));
        }
        if ((targetCommand = this.getTargetCommand()) == null) {
            builder.append(" <command>");
        } else {
            builder.append(CallingContext.getSubCommands(targetCommand));
        }
        this.getOptionsList().stream().filter(Option::isRequired).forEach(option -> {
            builder.append(' ').append(OptionUtils.toArgument((Option)ObjectUtils.notNull((Object)option)));
            if (option.hasArg()) {
                builder.append('=').append(option.getArgName());
            }
        });
        builder.append(" [<options>]");
        if (targetCommand != null) {
            builder.append(CallingContext.getExtraArguments(targetCommand));
        }
        String retval = builder.toString();
        assert (retval != null);
        return retval;
    }

    @NonNull
    private static CharSequence getSubCommands(@NonNull ICommand targetCommand) {
        Collection<ICommand> subCommands = targetCommand.getSubCommands();
        StringBuilder builder = new StringBuilder();
        if (!subCommands.isEmpty()) {
            builder.append(' ');
            if (!targetCommand.isSubCommandRequired()) {
                builder.append('[');
            }
            builder.append("<command>");
            if (!targetCommand.isSubCommandRequired()) {
                builder.append(']');
            }
        }
        return builder;
    }

    @NonNull
    private static CharSequence getExtraArguments(@NonNull ICommand targetCommand) {
        StringBuilder builder = new StringBuilder();
        for (ExtraArgument argument : targetCommand.getExtraArguments()) {
            builder.append(' ');
            if (!argument.isRequired()) {
                builder.append('[');
            }
            builder.append('<').append(argument.getName()).append('>');
            if (argument.getNumber() > 1) {
                builder.append("...");
            }
            if (argument.isRequired()) continue;
            builder.append(']');
        }
        return builder;
    }

    private static int getTerminalWidth() {
        String columns = System.getenv("COLUMNS");
        if (columns != null) {
            try {
                int width = Integer.parseInt(columns);
                if (width > 0) {
                    return width;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 80;
    }

    @NonNull
    static String wrapText(@NonNull String text, int maxWidth, @NonNull String indent) {
        if (maxWidth <= 0) {
            throw new IllegalArgumentException("maxWidth must be positive, got: " + maxWidth);
        }
        if (indent.length() >= maxWidth) {
            throw new IllegalArgumentException("indent length (" + indent.length() + ") must be less than maxWidth (" + maxWidth + ")");
        }
        if (text.length() <= maxWidth) {
            return text;
        }
        StringBuilder result = new StringBuilder(text.length() + 32);
        int lineStart = 0;
        boolean firstLine = true;
        int effectiveWidth = maxWidth;
        while (lineStart < text.length()) {
            int remaining;
            if (!firstLine) {
                result.append(System.lineSeparator()).append(indent);
                effectiveWidth = maxWidth - indent.length();
            }
            if ((remaining = text.length() - lineStart) <= effectiveWidth) {
                result.append(text.substring(lineStart));
                break;
            }
            int lineEnd = lineStart + effectiveWidth;
            int lastSpace = text.lastIndexOf(32, lineEnd);
            if (lastSpace <= lineStart) {
                result.append(text, lineStart, lineEnd);
                lineStart = lineEnd;
            } else {
                result.append(text, lineStart, lastSpace);
                lineStart = lastSpace + 1;
            }
            firstLine = false;
        }
        return (String)ObjectUtils.notNull((Object)result.toString());
    }

    public void showHelp() {
        PrintStream out = this.cliProcessor.getOutputStream();
        int terminalWidth = CallingContext.getTerminalWidth();
        try (PrintWriter writer = new PrintWriter(AutoCloser.preventClose((OutputStream)out), true, StandardCharsets.UTF_8);){
            TextHelpAppendable appendable = new TextHelpAppendable((Appendable)writer);
            appendable.setMaxWidth(Math.max(terminalWidth, 50));
            HelpFormatter formatter = ((HelpFormatter.Builder)((HelpFormatter.Builder)HelpFormatter.builder().setHelpAppendable((HelpAppendable)appendable)).setOptionFormatBuilder(OptionFormatter.builder().setOptArgSeparator("="))).setShowSince(false).get();
            try {
                formatter.printHelp(this.buildHelpCliSyntax(), CallingContext.buildHelpHeader(), this.toOptions(), "", false);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to write help output", ex);
            }
            writer.print(this.buildHelpFooter(terminalWidth));
            writer.flush();
        }
    }
}

