/*
 * Decompiled with CFR 0.152.
 */
package dev.metaschema.cli.processor;

import dev.metaschema.cli.processor.AbstractExitStatus;
import dev.metaschema.cli.processor.ExitCode;
import dev.metaschema.core.util.CollectionUtil;
import dev.metaschema.core.util.ObjectUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;

public class MessageExitStatus
extends AbstractExitStatus {
    private final List<Object> messageArguments;

    public MessageExitStatus(@NonNull ExitCode code, Object ... messageArguments) {
        super(code);
        this.messageArguments = CollectionUtil.unmodifiableList((List)((List)ObjectUtils.notNull(Arrays.asList(messageArguments))));
    }

    @Override
    public String getMessage() {
        String format = this.lookupMessageForCode(this.getExitCode());
        return String.format(format, this.messageArguments.toArray());
    }

    private String lookupMessageForCode(ExitCode ignoredExitCode) {
        StringBuilder builder = new StringBuilder();
        for (int index = 1; index <= this.messageArguments.size(); ++index) {
            if (index > 1) {
                builder.append(' ');
            }
            builder.append("%s");
        }
        return builder.toString();
    }
}

