/*
 * Decompiled with CFR 0.152.
 */
package dev.metaschema.cli.processor.command;

import dev.metaschema.cli.processor.CallingContext;
import dev.metaschema.cli.processor.ExitCode;
import dev.metaschema.cli.processor.ExitStatus;
import dev.metaschema.cli.processor.command.ICommand;
import dev.metaschema.cli.processor.command.ICommandExecutor;
import dev.metaschema.core.util.ObjectUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;

public abstract class AbstractParentCommand
implements ICommand {
    @NonNull
    private final Map<String, ICommand> commandToSubcommandHandlerMap = (Map)ObjectUtils.notNull(Collections.synchronizedMap(new LinkedHashMap()));

    protected AbstractParentCommand() {
    }

    protected final void addCommandHandler(ICommand handler) {
        String commandName = handler.getName();
        this.commandToSubcommandHandlerMap.put(commandName, handler);
    }

    @Override
    public ICommand getSubCommandByName(String name) {
        return this.commandToSubcommandHandlerMap.get(name);
    }

    @Override
    public Collection<ICommand> getSubCommands() {
        return (Collection)ObjectUtils.notNull(Collections.unmodifiableCollection(this.commandToSubcommandHandlerMap.values()));
    }

    @Override
    public boolean isSubCommandRequired() {
        return true;
    }

    @Override
    public ICommandExecutor newExecutor(CallingContext callingContext, CommandLine cmdLine) {
        return ICommandExecutor.using(callingContext, cmdLine, this::executeCommand);
    }

    @NonNull
    private ExitStatus executeCommand(@NonNull CallingContext callingContext, @NonNull CommandLine commandLine) {
        callingContext.showHelp();
        ExitStatus status = this.isSubCommandRequired() ? ExitCode.INVALID_COMMAND.exitMessage("Please use one of the following sub-commands: " + this.getSubCommands().stream().map(ICommand::getName).collect(Collectors.joining(", "))) : ExitCode.OK.exit();
        return status;
    }
}

