/*
 * Decompiled with CFR 0.152.
 */
package dev.metaschema.cli.processor.command;

import dev.metaschema.cli.processor.ExitCode;
import dev.metaschema.cli.processor.ExitStatus;
import edu.umd.cs.findbugs.annotations.NonNull;

public class CommandExecutionException
extends Exception {
    private final ExitCode exitCode;
    private static final long serialVersionUID = 1L;

    public CommandExecutionException(@NonNull ExitCode code) {
        this.exitCode = code;
    }

    public CommandExecutionException(@NonNull ExitCode code, String message) {
        super(message);
        this.exitCode = code;
    }

    public CommandExecutionException(@NonNull ExitCode code, Throwable cause) {
        super(cause);
        this.exitCode = code;
    }

    public CommandExecutionException(@NonNull ExitCode code, String message, Throwable cause) {
        super(message, cause);
        this.exitCode = code;
    }

    @NonNull
    public ExitStatus toExitStatus() {
        String message = this.getLocalizedMessage();
        ExitStatus retval = message == null ? this.exitCode.exit() : this.exitCode.exitMessage(message);
        Throwable cause = this.getCause();
        if (cause != null) {
            retval.withThrowable(cause);
        }
        return retval;
    }
}

