/*
 * Decompiled with CFR 0.152.
 */
package dev.metaschema.cli.processor.command;

import dev.metaschema.cli.processor.CallingContext;
import dev.metaschema.cli.processor.InvalidArgumentException;
import dev.metaschema.cli.processor.command.ExtraArgument;
import dev.metaschema.cli.processor.command.ICommandExecutor;
import dev.metaschema.core.util.CollectionUtil;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public interface ICommand {
    @NonNull
    public String getName();

    @NonNull
    public String getDescription();

    @NonNull
    default public List<ExtraArgument> getExtraArguments() {
        return CollectionUtil.emptyList();
    }

    @NonNull
    default public Collection<? extends Option> gatherOptions() {
        return CollectionUtil.emptyList();
    }

    @NonNull
    default public Collection<ICommand> getSubCommands() {
        return CollectionUtil.emptyList();
    }

    @Nullable
    default public ICommand getSubCommandByName(@NonNull String name) {
        return null;
    }

    default public boolean isSubCommandRequired() {
        return false;
    }

    default public void validateOptions(@NonNull CallingContext callingContext, @NonNull CommandLine commandLine) throws InvalidArgumentException {
    }

    @NonNull
    public ICommandExecutor newExecutor(@NonNull CallingContext var1, @NonNull CommandLine var2);

    default public void validateExtraArguments(@NonNull CallingContext callingContext, @NonNull CommandLine commandLine) throws InvalidArgumentException {
        this.validateSubCommandRequirement();
        this.validateArgumentCount(commandLine);
        this.validateRequiredArguments(commandLine);
    }

    private void validateSubCommandRequirement() throws InvalidArgumentException {
        if (this.isSubCommandRequired()) {
            throw new InvalidArgumentException("Please choose a valid sub-command.");
        }
    }

    private void validateArgumentCount(@NonNull CommandLine commandLine) throws InvalidArgumentException {
        List<ExtraArgument> extraArguments = this.getExtraArguments();
        int maxArguments = extraArguments.size();
        List actualArgs = commandLine.getArgList();
        if (actualArgs.size() > maxArguments) {
            throw new InvalidArgumentException(String.format("Too many extra arguments provided. Expected at most %d, but got %d.", maxArguments, actualArgs.size()));
        }
    }

    private void validateRequiredArguments(@NonNull CommandLine commandLine) throws InvalidArgumentException {
        List actualArgs = commandLine.getArgList();
        List requiredExtraArguments = this.getExtraArguments().stream().filter(ExtraArgument::isRequired).collect(Collectors.toUnmodifiableList());
        if (actualArgs.size() < requiredExtraArguments.size()) {
            throw new InvalidArgumentException(String.format("Missing required arguments: %s. Expected %d required arguments, but got %d.", requiredExtraArguments.stream().map(arg -> "<" + arg.getName() + ">").collect(Collectors.joining(" ")), requiredExtraArguments.size(), actualArgs.size()));
        }
    }
}

