/*
 * Decompiled with CFR 0.152.
 */
package dev.metaschema.cli.processor.command;

import dev.metaschema.cli.processor.CLIProcessor;
import dev.metaschema.cli.processor.CallingContext;
import dev.metaschema.cli.processor.ExitCode;
import dev.metaschema.cli.processor.command.AbstractTerminalCommand;
import dev.metaschema.cli.processor.command.CommandExecutionException;
import dev.metaschema.cli.processor.command.ExtraArgument;
import dev.metaschema.cli.processor.command.ICommandExecutor;
import dev.metaschema.cli.processor.completion.CompletionScriptGenerator;
import dev.metaschema.core.util.ObjectUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class ShellCompletionCommand
extends AbstractTerminalCommand {
    @NonNull
    private static final String COMMAND = "shell-completion";
    @NonNull
    private static final List<ExtraArgument> EXTRA_ARGUMENTS = (List)ObjectUtils.notNull(List.of(ExtraArgument.newInstance("shell", true)));
    @NonNull
    private static final Option TO_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("to").hasArg().argName("FILE").type(File.class).desc("write completion script to this file instead of stdout").get());

    @Override
    public String getName() {
        return COMMAND;
    }

    @Override
    public String getDescription() {
        return "Generate shell completion script for bash or zsh";
    }

    @Override
    public Collection<? extends Option> gatherOptions() {
        return List.of(TO_OPTION);
    }

    @Override
    public List<ExtraArgument> getExtraArguments() {
        return EXTRA_ARGUMENTS;
    }

    @Override
    public ICommandExecutor newExecutor(CallingContext callingContext, CommandLine cmdLine) {
        return ICommandExecutor.using(callingContext, cmdLine, this::executeCommand);
    }

    protected void executeCommand(@NonNull CallingContext callingContext, @NonNull CommandLine cmdLine) throws CommandExecutionException {
        Shell shell;
        List extraArgs = cmdLine.getArgList();
        if (extraArgs.isEmpty()) {
            throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, "Shell type is required. Supported shells: bash, zsh");
        }
        try {
            shell = Shell.fromString((String)ObjectUtils.notNull((Object)((String)extraArgs.get(0))));
        }
        catch (IllegalArgumentException ex) {
            throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, ex.getMessage());
        }
        CLIProcessor processor = callingContext.getCLIProcessor();
        CompletionScriptGenerator generator = new CompletionScriptGenerator(processor.getExec(), processor.getTopLevelCommands());
        String script = shell == Shell.BASH ? generator.generateBashCompletion() : generator.generateZshCompletion();
        String outputFile = cmdLine.getOptionValue(TO_OPTION);
        if (outputFile != null) {
            ShellCompletionCommand.writeToFile(outputFile, script);
        } else {
            ShellCompletionCommand.writeToStdout(script);
        }
    }

    private static void writeToFile(@NonNull String outputFile, @NonNull String script) throws CommandExecutionException {
        Path path = ShellCompletionCommand.resolveAgainstCWD((Path)ObjectUtils.notNull((Object)Path.of(outputFile, new String[0])));
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(script);
        }
        catch (IOException ex) {
            throw new CommandExecutionException(ExitCode.IO_ERROR, "Failed to write completion script to: " + String.valueOf(path), ex);
        }
    }

    private static void writeToStdout(@NonNull String script) {
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8), true);
        writer.print(script);
        writer.flush();
    }

    public static enum Shell {
        BASH("bash"),
        ZSH("zsh");

        @NonNull
        private final String name;

        private Shell(String name) {
            this.name = name;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public static Shell fromString(@NonNull String value) {
            String normalized = value.toLowerCase(Locale.ROOT);
            for (Shell shell : Shell.values()) {
                if (!shell.name.equals(normalized)) continue;
                return shell;
            }
            throw new IllegalArgumentException("Unknown shell: " + value + ". Supported shells: bash, zsh");
        }
    }
}

