/*
 * Decompiled with CFR 0.152.
 */
package dev.metaschema.cli.processor.completion;

import dev.metaschema.cli.processor.command.ExtraArgument;
import dev.metaschema.cli.processor.command.ICommand;
import dev.metaschema.cli.processor.completion.CompletionTypeRegistry;
import dev.metaschema.cli.processor.completion.ICompletionType;
import dev.metaschema.core.util.ObjectUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;

public class CompletionScriptGenerator {
    @NonNull
    private final String programName;
    @NonNull
    private final List<ICommand> commands;

    public CompletionScriptGenerator(@NonNull String programName, @NonNull List<ICommand> commands) {
        this.programName = programName;
        this.commands = commands;
    }

    @NonNull
    public String getProgramName() {
        return this.programName;
    }

    @NonNull
    public List<ICommand> getCommands() {
        return this.commands;
    }

    @NonNull
    public String generateBashCompletion() {
        StringBuilder sb = new StringBuilder();
        String funcName = "_" + CompletionScriptGenerator.sanitizeFunctionName(this.programName);
        sb.append("# Bash completion for ").append(this.programName).append("\n");
        sb.append("# Generated by metaschema cli-processor\n\n");
        sb.append("# Provide fallback if _init_completion is not available\n");
        sb.append("if ! type _init_completion &>/dev/null; then\n");
        sb.append("    _init_completion() {\n");
        sb.append("        COMPREPLY=()\n");
        sb.append("        cur=\"${COMP_WORDS[COMP_CWORD]}\"\n");
        sb.append("        prev=\"${COMP_WORDS[COMP_CWORD-1]}\"\n");
        sb.append("        words=(\"${COMP_WORDS[@]}\")\n");
        sb.append("        cword=$COMP_CWORD\n");
        sb.append("    }\n");
        sb.append("fi\n\n");
        sb.append("# Provide fallback if _filedir is not available\n");
        sb.append("if ! type _filedir &>/dev/null; then\n");
        sb.append("    _filedir() {\n");
        sb.append("        COMPREPLY=($(compgen -f -- \"$cur\"))\n");
        sb.append("    }\n");
        sb.append("fi\n\n");
        sb.append(funcName).append("() {\n");
        sb.append("    local cur prev words cword\n");
        sb.append("    _init_completion || return\n\n");
        String commandNames = this.commands.stream().map(ICommand::getName).collect(Collectors.joining(" "));
        sb.append("    local commands=\"").append(commandNames).append("\"\n\n");
        sb.append("    case \"${words[1]}\" in\n");
        for (ICommand cmd : this.commands) {
            this.generateBashCommandCase(sb, cmd, 2);
        }
        sb.append("        *)\n");
        sb.append("            COMPREPLY=($(compgen -W \"$commands\" -- \"$cur\"))\n");
        sb.append("            ;;\n");
        sb.append("    esac\n");
        sb.append("}\n\n");
        sb.append("complete -F ").append(funcName).append(" ").append(this.programName).append("\n");
        return (String)ObjectUtils.notNull((Object)sb.toString());
    }

    @NonNull
    public String generateZshCompletion() {
        StringBuilder sb = new StringBuilder();
        String funcName = "_" + CompletionScriptGenerator.sanitizeFunctionName(this.programName);
        sb.append("#compdef ").append(this.programName).append("\n\n");
        sb.append("# Zsh completion for ").append(this.programName).append("\n");
        sb.append("# Generated by metaschema cli-processor\n\n");
        sb.append(funcName).append("() {\n");
        sb.append("    local -a commands\n");
        sb.append("    commands=(\n");
        for (ICommand cmd : this.commands) {
            String escaped = cmd.getDescription().replace("'", "'\\''");
            sb.append("        '").append(cmd.getName()).append(":").append(escaped).append("'\n");
        }
        sb.append("    )\n\n");
        sb.append("    _arguments -C \\\n");
        sb.append("        '1:command:->command' \\\n");
        sb.append("        '*::arg:->args'\n\n");
        sb.append("    case $state in\n");
        sb.append("        command)\n");
        sb.append("            _describe 'command' commands\n");
        sb.append("            ;;\n");
        sb.append("        args)\n");
        sb.append("            case $words[1] in\n");
        for (ICommand cmd : this.commands) {
            CompletionScriptGenerator.generateZshCommandCase(sb, cmd);
        }
        sb.append("            esac\n");
        sb.append("            ;;\n");
        sb.append("    esac\n");
        sb.append("}\n\n");
        sb.append(funcName).append(" \"$@\"\n");
        return (String)ObjectUtils.notNull((Object)sb.toString());
    }

    private void generateBashCommandCase(StringBuilder sb, ICommand cmd, int depth) {
        String indent = "        ".repeat(Math.max(1, depth - 1));
        sb.append(indent).append(cmd.getName()).append(")\n");
        Collection<? extends Option> options = cmd.gatherOptions();
        List<ExtraArgument> extraArgs = cmd.getExtraArguments();
        Collection<ICommand> subCommands = cmd.getSubCommands();
        if (!subCommands.isEmpty()) {
            String subCmdNames = subCommands.stream().map(ICommand::getName).collect(Collectors.joining(" "));
            sb.append(indent).append("    if [[ ${#words[@]} -eq ").append(depth).append(" ]]; then\n");
            sb.append(indent).append("        COMPREPLY=($(compgen -W \"").append(subCmdNames).append("\" -- \"$cur\"))\n");
            sb.append(indent).append("    else\n");
            sb.append(indent).append("        case \"${words[").append(depth).append("]}\" in\n");
            for (ICommand subCmd : subCommands) {
                this.generateBashCommandCase(sb, subCmd, depth + 1);
            }
            sb.append(indent).append("        esac\n");
            sb.append(indent).append("    fi\n");
        } else {
            String extraArgCompletion;
            String optionNames = options.stream().map(CompletionScriptGenerator::getBashOptionName).collect(Collectors.joining(" "));
            sb.append(indent).append("    if [[ \"$cur\" == -* ]]; then\n");
            sb.append(indent).append("        COMPREPLY=($(compgen -W \"").append(optionNames).append("\" -- \"$cur\"))\n");
            sb.append(indent).append("    else\n");
            boolean hasOptionCompletion = false;
            for (Option option : options) {
                String completion;
                if (!option.hasArg() || (completion = CompletionScriptGenerator.getCompletionForOption(option, Shell.BASH)).isEmpty()) continue;
                if (!hasOptionCompletion) {
                    sb.append(indent).append("        case \"$prev\" in\n");
                    hasOptionCompletion = true;
                }
                String optNames = CompletionScriptGenerator.getBashOptionName(option);
                sb.append(indent).append("            ").append(optNames.replace(" ", "|")).append(")\n");
                sb.append(indent).append("                COMPREPLY=($(").append(completion).append(" -- \"$cur\"))\n");
                sb.append(indent).append("                ;;\n");
            }
            if (hasOptionCompletion) {
                sb.append(indent).append("            *)\n");
            }
            if (!(extraArgCompletion = CompletionScriptGenerator.getDefaultExtraArgumentCompletion(extraArgs, Shell.BASH)).isEmpty()) {
                sb.append(indent).append("                ").append(extraArgCompletion).append("\n");
            }
            if (hasOptionCompletion) {
                sb.append(indent).append("                ;;\n");
                sb.append(indent).append("        esac\n");
            }
            sb.append(indent).append("    fi\n");
        }
        sb.append(indent).append("    ;;\n");
    }

    private static void generateZshCommandCase(StringBuilder sb, ICommand cmd) {
        sb.append("                ").append(cmd.getName()).append(")\n");
        Collection<? extends Option> options = cmd.gatherOptions();
        List<ExtraArgument> extraArgs = cmd.getExtraArguments();
        sb.append("                    _arguments \\\n");
        for (Option option : options) {
            String optSpec = CompletionScriptGenerator.getZshOptionSpec(option);
            sb.append("                        ").append(optSpec).append(" \\\n");
        }
        int argNum = 1;
        for (ExtraArgument arg : extraArgs) {
            String required;
            String completion = CompletionScriptGenerator.getCompletionForExtraArgument(arg, Shell.ZSH);
            String string = required = arg.isRequired() ? "" : "::";
            if (completion.isEmpty()) {
                completion = " ";
            }
            sb.append("                        '").append(required.isEmpty() ? Integer.valueOf(argNum) : "").append(required).append(arg.getName()).append(":").append(completion).append("' \\\n");
            ++argNum;
        }
        int n = sb.lastIndexOf(" \\");
        if (n > 0) {
            sb.delete(n, n + 2);
        }
        sb.append("\n");
        sb.append("                    ;;\n");
    }

    @NonNull
    private static String getBashOptionName(Option opt) {
        StringBuilder sb = new StringBuilder();
        if (opt.getOpt() != null) {
            sb.append("-").append(opt.getOpt());
        }
        if (opt.getLongOpt() != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("--").append(opt.getLongOpt());
        }
        return (String)ObjectUtils.notNull((Object)sb.toString());
    }

    @NonNull
    private static String getZshOptionSpec(Option opt) {
        StringBuilder sb = new StringBuilder("'");
        if (opt.getLongOpt() != null) {
            sb.append("--").append(opt.getLongOpt());
        } else if (opt.getOpt() != null) {
            sb.append("-").append(opt.getOpt());
        }
        String desc = opt.getDescription();
        if (desc != null) {
            desc = desc.replace("'", "'\\''");
            sb.append("[").append(desc).append("]");
        }
        if (opt.hasArg()) {
            String argName = opt.getArgName();
            if (argName == null) {
                argName = "arg";
            }
            String completion = CompletionScriptGenerator.getCompletionForOption(opt, Shell.ZSH);
            sb.append(":").append(argName).append(":").append(completion);
        }
        sb.append("'");
        return (String)ObjectUtils.notNull((Object)sb.toString());
    }

    @NonNull
    private static String getCompletionForOption(Option opt, Shell shell) {
        Object typeObj = opt.getType();
        Class type = typeObj instanceof Class ? (Class)typeObj : null;
        ICompletionType completion = CompletionTypeRegistry.lookup(type);
        if (completion != null) {
            return shell == Shell.BASH ? completion.getBashCompletion() : completion.getZshCompletion();
        }
        return "";
    }

    @NonNull
    private static String getCompletionForExtraArgument(ExtraArgument arg, Shell shell) {
        Class<?> type = arg.getType();
        ICompletionType completion = CompletionTypeRegistry.lookup(type);
        if (completion != null) {
            return shell == Shell.BASH ? completion.getBashCompletion() : completion.getZshCompletion();
        }
        return "";
    }

    @NonNull
    private static String getDefaultExtraArgumentCompletion(List<ExtraArgument> args, Shell shell) {
        String completion;
        if (!args.isEmpty() && !(completion = CompletionScriptGenerator.getCompletionForExtraArgument(args.get(0), shell)).isEmpty()) {
            return completion;
        }
        if (shell == Shell.BASH) {
            return "_filedir";
        }
        return "_files";
    }

    @NonNull
    private static String sanitizeFunctionName(String name) {
        return (String)ObjectUtils.notNull((Object)name.replaceAll("[^a-zA-Z0-9_]", "_"));
    }

    public static enum Shell {
        BASH,
        ZSH;

    }
}

