/*
 * Decompiled with CFR 0.152.
 */
package dev.metaschema.cli.processor.completion;

import dev.metaschema.cli.processor.completion.ICompletionType;
import dev.metaschema.core.util.ObjectUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public final class CompletionTypeRegistry {
    private static final Map<Class<?>, ICompletionType> REGISTRY = new ConcurrentHashMap();

    private CompletionTypeRegistry() {
    }

    public static void register(@NonNull Class<?> type, @NonNull ICompletionType completion) {
        REGISTRY.put(type, completion);
    }

    public static <E extends Enum<E>> void registerEnum(@NonNull Class<E> enumClass) {
        CompletionTypeRegistry.register(enumClass, CompletionTypeRegistry.forEnum(enumClass));
    }

    @NonNull
    public static <E extends Enum<E>> ICompletionType forEnum(@NonNull Class<E> enumClass) {
        String values = (String)ObjectUtils.notNull((Object)Arrays.stream((Enum[])enumClass.getEnumConstants()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(" ")));
        return new EnumCompletionType(values);
    }

    @Nullable
    public static ICompletionType lookup(@Nullable Class<?> type) {
        return type == null ? null : REGISTRY.get(type);
    }

    static {
        CompletionTypeRegistry.register(File.class, new FileCompletionType());
        CompletionTypeRegistry.register(URI.class, new UriCompletionType());
        CompletionTypeRegistry.register(URL.class, new UriCompletionType());
    }

    private static final class EnumCompletionType
    implements ICompletionType {
        @NonNull
        private final String values;

        EnumCompletionType(@NonNull String values) {
            this.values = values;
        }

        @Override
        public String getBashCompletion() {
            return "compgen -W \"" + this.values + "\"";
        }

        @Override
        public String getZshCompletion() {
            return "(" + this.values + ")";
        }
    }

    private static final class FileCompletionType
    implements ICompletionType {
        private FileCompletionType() {
        }

        @Override
        public String getBashCompletion() {
            return "_filedir";
        }

        @Override
        public String getZshCompletion() {
            return "_files";
        }
    }

    private static final class UriCompletionType
    implements ICompletionType {
        private UriCompletionType() {
        }

        @Override
        public String getBashCompletion() {
            return "";
        }

        @Override
        public String getZshCompletion() {
            return "_urls";
        }
    }
}

