/*
 * Decompiled with CFR 0.152.
 */
package io.pdfapi.client.http;

import io.pdfapi.client.http.AbstractHttpClient;
import io.pdfapi.client.http.HttpResponse;
import io.pdfapi.client.http.StreamingHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class OkHttpClient
extends AbstractHttpClient {
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private final okhttp3.OkHttpClient client;

    public OkHttpClient(int timeoutSeconds) {
        this.client = new OkHttpClient.Builder().connectTimeout((long)timeoutSeconds, TimeUnit.SECONDS).readTimeout((long)timeoutSeconds, TimeUnit.SECONDS).writeTimeout((long)timeoutSeconds, TimeUnit.SECONDS).build();
    }

    public OkHttpClient(okhttp3.OkHttpClient client) {
        this.client = client;
    }

    @Override
    protected CompletableFuture<HttpResponse> executePost(String url, Map<String, String> headers, String jsonBody) {
        Request request = new Request.Builder().url(url).headers(Headers.of(headers)).post(RequestBody.create((String)jsonBody, (MediaType)JSON)).build();
        return this.executeAsync(request);
    }

    @Override
    protected CompletableFuture<HttpResponse> executePost(String url, Map<String, String> headers, String fileName, InputStream content, String contentType, String partName) {
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(partName, fileName, (RequestBody)new InputStreamRequestBody(MediaType.get((String)contentType), content)).build();
        Request request = new Request.Builder().url(url).headers(Headers.of(headers)).post((RequestBody)requestBody).build();
        return this.executeAsync(request);
    }

    @Override
    protected CompletableFuture<HttpResponse> executeGet(String url, Map<String, String> headers) {
        Request request = new Request.Builder().url(url).headers(Headers.of(headers)).get().build();
        return this.executeAsync(request);
    }

    private CompletableFuture<HttpResponse> executeAsync(Request request) {
        final CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }

            public void onResponse(Call call, Response response) {
                ResponseBody body = response.body();
                if (body != null) {
                    future.complete(new StreamingHttpResponse(response.code(), body.byteStream(), (AutoCloseable)response, response.headers().toMultimap()));
                } else {
                    response.close();
                    future.complete(new StreamingHttpResponse(response.code(), null, null, response.headers().toMultimap()));
                }
            }
        });
        return future;
    }

    @Override
    protected void closeInternal() {
        this.client.dispatcher().executorService().shutdown();
        this.client.connectionPool().evictAll();
    }

    private static class InputStreamRequestBody
    extends RequestBody {
        private final MediaType contentType;
        private final InputStream inputStream;

        InputStreamRequestBody(MediaType contentType, InputStream inputStream) {
            this.contentType = contentType;
            this.inputStream = inputStream;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            try (Source source = Okio.source((InputStream)this.inputStream);){
                sink.writeAll(source);
            }
        }
    }
}

