/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.util;

import dev.secondsun.geometry.Model;
import dev.secondsun.geometry.Triangle;
import dev.secondsun.util.Maths;
import dev.secondsun.util.Plane;

public class BoundedCube {
    public final Model model;
    public float top = -1000000.0f;
    public float bottom = 1000000.0f;
    public float left = 1000000.0f;
    public float right = -1000000.0f;
    public float near = -1000000.0f;
    public float far = 1000000.0f;

    public BoundedCube(Model model) {
        this.model = model;
        for (Triangle tri : model.getTriangles()) {
            float maxX = Maths.max(tri.v1.x, tri.v2.x, tri.v3.x);
            float minX = Maths.min(tri.v1.x, tri.v2.x, tri.v3.x);
            float maxY = Maths.max(tri.v1.y, tri.v2.y, tri.v3.y);
            float minY = Maths.min(tri.v1.y, tri.v2.y, tri.v3.y);
            float maxZ = Maths.max(tri.v1.z, tri.v2.z, tri.v3.z);
            float minZ = Maths.min(tri.v1.z, tri.v2.z, tri.v3.z);
            if (maxX > this.right) {
                this.right = maxX;
            }
            if (minX < this.left) {
                this.left = minX;
            }
            if (maxY > this.top) {
                this.top = maxY;
            }
            if (minY < this.bottom) {
                this.bottom = minY;
            }
            if (maxZ >= this.near) {
                this.near = maxZ;
            }
            if (!(minZ < this.far)) continue;
            this.far = minZ;
        }
    }

    public boolean isBehind(Plane partition) {
        for (Triangle tri : this.model.getTriangles()) {
            if (tri.v1.isBehind(partition) && tri.v2.isBehind(partition) && tri.v3.isBehind(partition)) continue;
            return false;
        }
        return true;
    }

    public boolean isInFront(Plane partition) {
        for (Triangle tri : this.model.getTriangles()) {
            if (tri.v1.isInFront(partition) && tri.v2.isInFront(partition) && tri.v3.isInFront(partition)) continue;
            return false;
        }
        return true;
    }
}

