/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun;

import dev.secondsun.game.ScanLineEngine;
import dev.secondsun.geometry.Camera;
import dev.secondsun.geometry.Triangle;
import dev.secondsun.geometry.Vertex;
import dev.secondsun.geometry.Vertex2D;
import dev.secondsun.geometry.playfield.DormRoom;
import dev.secondsun.util.BSPTree;
import dev.secondsun.util.Resources;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JFrame;

public class Main {
    public static void main(String[] args) {
        JFrame frame = new JFrame("3D Engine");
        frame.setSize(800, 600);
        frame.add(new Screen());
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public static class Screen
    extends Component {
        private final Resources resources = new Resources();
        private final int scale = 1;
        private final int screenWidth = 128;
        private final int screenHeight = 160;
        private int rotY = 64;
        private int rotX = 100;
        private int theta = 45;

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            DormRoom board = new DormRoom(this.resources);
            ScanLineEngine engine = new ScanLineEngine(128, 160, board, this.resources);
            Camera camera = new Camera(new Vertex(this.rotX, this.rotY, 100.0f), new Vertex(96.0f, 32.0f, 50.0f));
            board.lookAt(camera, new Vertex2D(1.5f, 1.5f), new Vertex2D(120.0f, 80.0f));
            List<Triangle> tiles = board.getTriangles();
            BSPTree tree = board.getBSPTree();
            tiles = tree.order(tiles, camera);
            BufferedImage image = engine.draw(tiles);
            g.drawImage(image.getScaledInstance(this.getWidth(), this.getHeight(), 2), 0, 0, null);
            try {
                Thread.sleep(33L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++this.theta;
            this.rotX = (int)(300.0 * Math.cos(Math.toRadians(this.theta)) + 100.0);
            this.rotY = (int)(-300.0 * Math.sin(Math.toRadians(this.theta)) + 32.0);
            this.repaint();
        }
    }
}

